
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Baggage Disclosure Rule Code contextual list.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDiscloseRuleListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="D"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value="Y"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BagDiscloseRuleListType implements Serializable {
    /** 
     * Disclosure with NO US DOT Reservation
     */
    D("D"), /** 
             * No Disclosure or US DOT Reservation
             */
    N("N"), /** 
             * Disclosure AND US DOT Reservation
             */
    Y("Y"), OTHER("Other");
    private final String value;

    private BagDiscloseRuleListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BagDiscloseRuleListType convert(String value) {
        for (BagDiscloseRuleListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
