
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for US Department of Transportation (DOT) Reservation or Disclosure baggage rule.Select a value from the enumerated list or enter a string value.
 =enumerated values=
 N = NOT SUBJECT TO US DOT RESERVATION OR DISCLOSURE
 Y = SUBJECT TO US DOT RESERVATION AND DISCLOSURE
 D = SUBJECT TO DISCLOSURE BUT NOT TO US DOT RESERVATION
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BagRule"/>
 *     &lt;xs:element type="ns:Descriptions" name="Descriptions" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Remarks" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BagDisclosureType implements Serializable
{
    private String bagRule;
    private Descriptions descriptions;
    private Remarks remarks;
    private String refs;

    /** 
     * Get the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
    Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @return value
     */
    public String getBagRule() {
        return bagRule;
    }

    /** 
     * Set the 'BagRule' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule.
    Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @param bagRule
     */
    public void setBagRule(String bagRule) {
        this.bagRule = bagRule;
    }

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
