
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The BaggageAllowance transaction set provides checked and carry-on baggage allowance details. Request qualifiers may include Traveler, origin/ destination, point of sale, flight-specific and ticketed fare information. 

 The response returns the baggage allowance, whether or not IATA Reso 302 or DOT rules are applicable, baggage weight, dimensions and size information by origin/ destination pair. Implementers may also obtain an additional catalog of applicable embargoes and charges within the same origin and destination pair.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:BagAllowReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element type="ns:TicketIdentificationType" name="TicketIdentification" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:choice>
 *         &lt;xs:element ref="ns:ShoppingResponseID"/>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
 *               &lt;xs:element type="ns:FlightOnlyType" name="Flight" maxOccurs="unbounded"/>
 *               &lt;xs:element type="ns:ItemID_Type" name="OfferID"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="Preference" minOccurs="0">
 *         &lt;!-- Reference to inner class Preference -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="Qualifier" minOccurs="0">
 *         &lt;!-- Reference to inner class Qualifier -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:ItineraryType" name="JourneyData" minOccurs="0"/>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:BagAllowReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BaggageAllowanceRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private BagAllowReqParamsType parameters;
    private List<TicketIdentificationType> ticketIdentificationList = new ArrayList<TicketIdentificationType>();
    private int choiceSelect = -1;
    private static final int SHOPPING_RESPONSE_ID_CHOICE = 0;
    private static final int QUERY_CHOICE = 1;
    private ShoppingResponseIDType shoppingResponseID;
    private int querySelect = -1;
    private static final int QUERY_ORIGIN_DESTINATION_LIST_CHOICE = 0;
    private static final int QUERY_FLIGHT_LIST_CHOICE = 1;
    private static final int QUERY_OFFER_ID_CHOICE = 2;
    private List<FlightType> queryOriginDestinationList = new ArrayList<FlightType>();
    private List<FlightOnlyType> queryFlightList = new ArrayList<FlightOnlyType>();
    private ItemIDType queryOfferID;
    private Preference preference;
    private Qualifier qualifier;
    private ItineraryType journeyData;
    private DataLists dataLists;
    private BagAllowReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public BagAllowReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(BagAllowReqParamsType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the list of 'TicketIdentification' element items. Ticket identification group, can be associated per Traveler.
     * 
     * @return list
     */
    public List<TicketIdentificationType> getTicketIdentificationList() {
        return ticketIdentificationList;
    }

    /** 
     * Set the list of 'TicketIdentification' element items. Ticket identification group, can be associated per Traveler.
     * 
     * @param list
     */
    public void setTicketIdentificationList(List<TicketIdentificationType> list) {
        ticketIdentificationList = list;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ShoppingResponseID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponseID() {
        return choiceSelect == SHOPPING_RESPONSE_ID_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        setChoiceSelect(SHOPPING_RESPONSE_ID_CHOICE);
        this.shoppingResponseID = shoppingResponseID;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    private void setQuerySelect(int choice) {
        setChoiceSelect(QUERY_CHOICE);
        if (querySelect == -1) {
            querySelect = choice;
        } else if (querySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearQuerySelect() {
        querySelect = -1;
    }

    /** 
     * Check if QueryOriginDestinationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryOriginDestinationList() {
        return querySelect == QUERY_ORIGIN_DESTINATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestination' element items. Origin and Destination.
     * 
     * @return list
     */
    public List<FlightType> getQueryOriginDestinationList() {
        return queryOriginDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items. Origin and Destination.
     * 
     * @param list
     */
    public void setQueryOriginDestinationList(List<FlightType> list) {
        setQuerySelect(QUERY_ORIGIN_DESTINATION_LIST_CHOICE);
        queryOriginDestinationList = list;
    }

    /** 
     * Check if QueryFlightList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryFlightList() {
        return querySelect == QUERY_FLIGHT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Flight' element items. Flight origin/ destination information.
     * 
     * @return list
     */
    public List<FlightOnlyType> getQueryFlightList() {
        return queryFlightList;
    }

    /** 
     * Set the list of 'Flight' element items. Flight origin/ destination information.
     * 
     * @param list
     */
    public void setQueryFlightList(List<FlightOnlyType> list) {
        setQuerySelect(QUERY_FLIGHT_LIST_CHOICE);
        queryFlightList = list;
    }

    /** 
     * Check if QueryOfferID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryOfferID() {
        return querySelect == QUERY_OFFER_ID_CHOICE;
    }

    /** 
     * Get the 'OfferID' element value. Globally unique Offer instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes. Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @return value
     */
    public ItemIDType getQueryOfferID() {
        return queryOfferID;
    }

    /** 
     * Set the 'OfferID' element value. Globally unique Offer instance ID. It is not recommended to exceed 64, and it is not recommended to use dashes. Example: QWASZXERDFCVTYGHBNUIJKNMF67D5F9GHR567SWER41SD458F9456FMDIRTN34DF
     * 
     * @param queryOfferID
     */
    public void setQueryOfferID(ItemIDType queryOfferID) {
        setQuerySelect(QUERY_OFFER_ID_CHOICE);
        this.queryOfferID = queryOfferID;
    }

    /** 
     * Get the 'Preference' element value.
     * 
     * @return value
     */
    public Preference getPreference() {
        return preference;
    }

    /** 
     * Set the 'Preference' element value.
     * 
     * @param preference
     */
    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public Qualifier getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @return value
     */
    public ItineraryType getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @param journeyData
     */
    public void setJourneyData(ItineraryType journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public BagAllowReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(BagAllowReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Contains Shopping Preference choices, ie allowing to specify Airline, Alliance, Flight, Transfer and other shopping preferences.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Preference" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:AirlinePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AlliancePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FarePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:FlightPreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PricingMethodPreference" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SegMaxTimePreferences" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ServicePricingOnlyPreference" minOccurs="0"/>
     *       &lt;xs:element ref="ns:TransferPreferences" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Preference implements Serializable
    {
        private AirlinePreferencesType airlinePreferences;
        private AlliancePreferencesType alliancePreferences;
        private FarePreferencesType farePreferences;
        private FlightPreferencesType flightPreferences;
        private BestPricingPreferencesType pricingMethodPreference;
        private FltSegmentMaxTimePreferencesType segMaxTimePreferences;
        private ServicePricingOnlyPreference servicePricingOnlyPreference;
        private TransferPreferencesType transferPreferences;

        /** 
         * Get the 'AirlinePreferences' element value.
         * 
         * @return value
         */
        public AirlinePreferencesType getAirlinePreferences() {
            return airlinePreferences;
        }

        /** 
         * Set the 'AirlinePreferences' element value.
         * 
         * @param airlinePreferences
         */
        public void setAirlinePreferences(
                AirlinePreferencesType airlinePreferences) {
            this.airlinePreferences = airlinePreferences;
        }

        /** 
         * Get the 'AlliancePreferences' element value.
         * 
         * @return value
         */
        public AlliancePreferencesType getAlliancePreferences() {
            return alliancePreferences;
        }

        /** 
         * Set the 'AlliancePreferences' element value.
         * 
         * @param alliancePreferences
         */
        public void setAlliancePreferences(
                AlliancePreferencesType alliancePreferences) {
            this.alliancePreferences = alliancePreferences;
        }

        /** 
         * Get the 'FarePreferences' element value.
         * 
         * @return value
         */
        public FarePreferencesType getFarePreferences() {
            return farePreferences;
        }

        /** 
         * Set the 'FarePreferences' element value.
         * 
         * @param farePreferences
         */
        public void setFarePreferences(FarePreferencesType farePreferences) {
            this.farePreferences = farePreferences;
        }

        /** 
         * Get the 'FlightPreferences' element value.
         * 
         * @return value
         */
        public FlightPreferencesType getFlightPreferences() {
            return flightPreferences;
        }

        /** 
         * Set the 'FlightPreferences' element value.
         * 
         * @param flightPreferences
         */
        public void setFlightPreferences(FlightPreferencesType flightPreferences) {
            this.flightPreferences = flightPreferences;
        }

        /** 
         * Get the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
         * 
         * @return value
         */
        public BestPricingPreferencesType getPricingMethodPreference() {
            return pricingMethodPreference;
        }

        /** 
         * Set the 'PricingMethodPreference' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
         * 
         * @param pricingMethodPreference
         */
        public void setPricingMethodPreference(
                BestPricingPreferencesType pricingMethodPreference) {
            this.pricingMethodPreference = pricingMethodPreference;
        }

        /** 
         * Get the 'SegMaxTimePreferences' element value.
         * 
         * @return value
         */
        public FltSegmentMaxTimePreferencesType getSegMaxTimePreferences() {
            return segMaxTimePreferences;
        }

        /** 
         * Set the 'SegMaxTimePreferences' element value.
         * 
         * @param segMaxTimePreferences
         */
        public void setSegMaxTimePreferences(
                FltSegmentMaxTimePreferencesType segMaxTimePreferences) {
            this.segMaxTimePreferences = segMaxTimePreferences;
        }

        /** 
         * Get the 'ServicePricingOnlyPreference' element value.
         * 
         * @return value
         */
        public ServicePricingOnlyPreference getServicePricingOnlyPreference() {
            return servicePricingOnlyPreference;
        }

        /** 
         * Set the 'ServicePricingOnlyPreference' element value.
         * 
         * @param servicePricingOnlyPreference
         */
        public void setServicePricingOnlyPreference(
                ServicePricingOnlyPreference servicePricingOnlyPreference) {
            this.servicePricingOnlyPreference = servicePricingOnlyPreference;
        }

        /** 
         * Get the 'TransferPreferences' element value.
         * 
         * @return value
         */
        public TransferPreferencesType getTransferPreferences() {
            return transferPreferences;
        }

        /** 
         * Set the 'TransferPreferences' element value.
         * 
         * @param transferPreferences
         */
        public void setTransferPreferences(
                TransferPreferencesType transferPreferences) {
            this.transferPreferences = transferPreferences;
        }
    }
    /** 
     * Qualifier choices.

    These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of the capability is not dictated by this specification. 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Qualifier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:BaggagePricingQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ExistingOrderQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PaymentCardQualifiers" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element ref="ns:ProgramQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PromotionQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SeatQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:ServiceQualifier" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SocialMediaQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SpecialFareQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:SpecialNeedQualifiers" minOccurs="0"/>
     *       &lt;xs:element ref="ns:TripPurposeQualifier" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Qualifier implements Serializable
    {
        private BaggagePricingQualifierType baggagePricingQualifier;
        private ExistingOrderQualifier existingOrderQualifier;
        private List<CardQualifierType> paymentCardQualifierList = new ArrayList<CardQualifierType>();
        private ProgramQualifiers programQualifiers;
        private PromotionQualifiers promotionQualifiers;
        private SeatQualifier seatQualifier;
        private ServiceQualifierPriceType serviceQualifier;
        private SocialMediaQualifierType socialMediaQualifiers;
        private FareQualifierType specialFareQualifiers;
        private SpecialType specialNeedQualifiers;
        private TripPurposeQualifier tripPurposeQualifier;

        /** 
         * Get the 'BaggagePricingQualifier' element value.
         * 
         * @return value
         */
        public BaggagePricingQualifierType getBaggagePricingQualifier() {
            return baggagePricingQualifier;
        }

        /** 
         * Set the 'BaggagePricingQualifier' element value.
         * 
         * @param baggagePricingQualifier
         */
        public void setBaggagePricingQualifier(
                BaggagePricingQualifierType baggagePricingQualifier) {
            this.baggagePricingQualifier = baggagePricingQualifier;
        }

        /** 
         * Get the 'ExistingOrderQualifier' element value.
         * 
         * @return value
         */
        public ExistingOrderQualifier getExistingOrderQualifier() {
            return existingOrderQualifier;
        }

        /** 
         * Set the 'ExistingOrderQualifier' element value.
         * 
         * @param existingOrderQualifier
         */
        public void setExistingOrderQualifier(
                ExistingOrderQualifier existingOrderQualifier) {
            this.existingOrderQualifier = existingOrderQualifier;
        }

        /** 
         * Get the list of 'PaymentCardQualifiers' element items. Contains card type, and Issuer Identification Number. 
         * 
         * @return list
         */
        public List<CardQualifierType> getPaymentCardQualifierList() {
            return paymentCardQualifierList;
        }

        /** 
         * Set the list of 'PaymentCardQualifiers' element items. Contains card type, and Issuer Identification Number. 
         * 
         * @param list
         */
        public void setPaymentCardQualifierList(List<CardQualifierType> list) {
            paymentCardQualifierList = list;
        }

        /** 
         * Get the 'ProgramQualifiers' element value.
         * 
         * @return value
         */
        public ProgramQualifiers getProgramQualifiers() {
            return programQualifiers;
        }

        /** 
         * Set the 'ProgramQualifiers' element value.
         * 
         * @param programQualifiers
         */
        public void setProgramQualifiers(ProgramQualifiers programQualifiers) {
            this.programQualifiers = programQualifiers;
        }

        /** 
         * Get the 'PromotionQualifiers' element value.
         * 
         * @return value
         */
        public PromotionQualifiers getPromotionQualifiers() {
            return promotionQualifiers;
        }

        /** 
         * Set the 'PromotionQualifiers' element value.
         * 
         * @param promotionQualifiers
         */
        public void setPromotionQualifiers(
                PromotionQualifiers promotionQualifiers) {
            this.promotionQualifiers = promotionQualifiers;
        }

        /** 
         * Get the 'SeatQualifier' element value.
         * 
         * @return value
         */
        public SeatQualifier getSeatQualifier() {
            return seatQualifier;
        }

        /** 
         * Set the 'SeatQualifier' element value.
         * 
         * @param seatQualifier
         */
        public void setSeatQualifier(SeatQualifier seatQualifier) {
            this.seatQualifier = seatQualifier;
        }

        /** 
         * Get the 'ServiceQualifier' element value.
         * 
         * @return value
         */
        public ServiceQualifierPriceType getServiceQualifier() {
            return serviceQualifier;
        }

        /** 
         * Set the 'ServiceQualifier' element value.
         * 
         * @param serviceQualifier
         */
        public void setServiceQualifier(
                ServiceQualifierPriceType serviceQualifier) {
            this.serviceQualifier = serviceQualifier;
        }

        /** 
         * Get the 'SocialMediaQualifiers' element value.
         * 
         * @return value
         */
        public SocialMediaQualifierType getSocialMediaQualifiers() {
            return socialMediaQualifiers;
        }

        /** 
         * Set the 'SocialMediaQualifiers' element value.
         * 
         * @param socialMediaQualifiers
         */
        public void setSocialMediaQualifiers(
                SocialMediaQualifierType socialMediaQualifiers) {
            this.socialMediaQualifiers = socialMediaQualifiers;
        }

        /** 
         * Get the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

        Notes:
        1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

        2. Private Fares apply to ALL Travelers.
         * 
         * @return value
         */
        public FareQualifierType getSpecialFareQualifiers() {
            return specialFareQualifiers;
        }

        /** 
         * Set the 'SpecialFareQualifiers' element value. Contains elements identifying eligibility for special pricing, which may be private or negotiated.

        Notes:
        1. Supports pricing discounts and/ or other benefits for Travelers affiliated with companies with private fare and/ or negotiated rate contracts.

        2. Private Fares apply to ALL Travelers.
         * 
         * @param specialFareQualifiers
         */
        public void setSpecialFareQualifiers(
                FareQualifierType specialFareQualifiers) {
            this.specialFareQualifiers = specialFareQualifiers;
        }

        /** 
         * Get the 'SpecialNeedQualifiers' element value.
         * 
         * @return value
         */
        public SpecialType getSpecialNeedQualifiers() {
            return specialNeedQualifiers;
        }

        /** 
         * Set the 'SpecialNeedQualifiers' element value.
         * 
         * @param specialNeedQualifiers
         */
        public void setSpecialNeedQualifiers(SpecialType specialNeedQualifiers) {
            this.specialNeedQualifiers = specialNeedQualifiers;
        }

        /** 
         * Get the 'TripPurposeQualifier' element value.
         * 
         * @return value
         */
        public TripPurposeQualifier getTripPurposeQualifier() {
            return tripPurposeQualifier;
        }

        /** 
         * Set the 'TripPurposeQualifier' element value.
         * 
         * @param tripPurposeQualifier
         */
        public void setTripPurposeQualifier(
                TripPurposeQualifier tripPurposeQualifier) {
            this.tripPurposeQualifier = tripPurposeQualifier;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
