
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageCategoryListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CarryOn"/>
 *     &lt;xs:enumeration value="Checked"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BaggageCategoryListType implements Serializable {
    CARRY_ON("CarryOn"), CHECKED("Checked");
    private final String value;

    private BaggageCategoryListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BaggageCategoryListType convert(String value) {
        for (BaggageCategoryListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
