
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The BaggageList transaction set determines and returns a list of applicable bags for a specified itinerary or carrier.

 Request qualifiers may include Traveler, origin/ destination, flight-specific and ticketed fare information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageListRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:BagListReqParamsType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:choice>
 *         &lt;xs:element ref="ns:ShoppingResponseID"/>
 *         &lt;xs:element name="Query">
 *           &lt;xs:complexType>
 *             &lt;xs:choice>
 *               &lt;xs:element type="ns:FlightType" name="OriginDestination" maxOccurs="unbounded"/>
 *               &lt;xs:element type="ns:FlightOnlyType" name="Flight" maxOccurs="unbounded"/>
 *             &lt;/xs:choice>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *       &lt;xs:element ref="ns:Preference" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Qualifier" minOccurs="0"/>
 *       &lt;xs:element type="ns:ItineraryType" name="JourneyData" minOccurs="0"/>
 *       &lt;xs:element name="DataLists" minOccurs="0">
 *         &lt;!-- Reference to inner class DataLists -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:BagListReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BaggageListRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private BagListReqParamsType parameters;
    private int choiceSelect = -1;
    private static final int SHOPPING_RESPONSE_ID_CHOICE = 0;
    private static final int QUERY_CHOICE = 1;
    private ShoppingResponseIDType shoppingResponseID;
    private int querySelect = -1;
    private static final int QUERY_ORIGIN_DESTINATION_LIST_CHOICE = 0;
    private static final int QUERY_FLIGHT_LIST_CHOICE = 1;
    private List<FlightType> queryOriginDestinationList = new ArrayList<FlightType>();
    private List<FlightOnlyType> queryFlightList = new ArrayList<FlightOnlyType>();
    private Preference preference;
    private Qualifier qualifier;
    private ItineraryType journeyData;
    private DataLists dataLists;
    private BagListReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public BagListReqParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(BagListReqParamsType parameters) {
        this.parameters = parameters;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ShoppingResponseID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponseID() {
        return choiceSelect == SHOPPING_RESPONSE_ID_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        setChoiceSelect(SHOPPING_RESPONSE_ID_CHOICE);
        this.shoppingResponseID = shoppingResponseID;
    }

    /** 
     * Check if Query is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQuery() {
        return choiceSelect == QUERY_CHOICE;
    }

    private void setQuerySelect(int choice) {
        setChoiceSelect(QUERY_CHOICE);
        if (querySelect == -1) {
            querySelect = choice;
        } else if (querySelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearQuerySelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearQuerySelect() {
        querySelect = -1;
    }

    /** 
     * Check if QueryOriginDestinationList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryOriginDestinationList() {
        return querySelect == QUERY_ORIGIN_DESTINATION_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestination' element items. Origin and Destination.
     * 
     * @return list
     */
    public List<FlightType> getQueryOriginDestinationList() {
        return queryOriginDestinationList;
    }

    /** 
     * Set the list of 'OriginDestination' element items. Origin and Destination.
     * 
     * @param list
     */
    public void setQueryOriginDestinationList(List<FlightType> list) {
        setQuerySelect(QUERY_ORIGIN_DESTINATION_LIST_CHOICE);
        queryOriginDestinationList = list;
    }

    /** 
     * Check if QueryFlightList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifQueryFlightList() {
        return querySelect == QUERY_FLIGHT_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Flight' element items. Flight origin/ destination information.
     * 
     * @return list
     */
    public List<FlightOnlyType> getQueryFlightList() {
        return queryFlightList;
    }

    /** 
     * Set the list of 'Flight' element items. Flight origin/ destination information.
     * 
     * @param list
     */
    public void setQueryFlightList(List<FlightOnlyType> list) {
        setQuerySelect(QUERY_FLIGHT_LIST_CHOICE);
        queryFlightList = list;
    }

    /** 
     * Get the 'Preference' element value.
     * 
     * @return value
     */
    public Preference getPreference() {
        return preference;
    }

    /** 
     * Set the 'Preference' element value.
     * 
     * @param preference
     */
    public void setPreference(Preference preference) {
        this.preference = preference;
    }

    /** 
     * Get the 'Qualifier' element value.
     * 
     * @return value
     */
    public Qualifier getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value.
     * 
     * @param qualifier
     */
    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @return value
     */
    public ItineraryType getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Existing Flight Itinerary Information.
     * 
     * @param journeyData
     */
    public void setJourneyData(ItineraryType journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public BagListReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(BagListReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PassengerList" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContactList" minOccurs="0">
     *         &lt;!-- Reference to inner class ContactList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
