
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The BaggageList transaction set determines and returns a list of applicable bags for a specified itinerary or carrier.

 Request qualifiers may include Traveler, origin/ destination, flight-specific and ticketed fare information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageListRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element type="ns:ProcessingResultType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element type="ns:BagListResParamsType" name="Parameters" minOccurs="0"/>
 *         &lt;xs:element ref="ns:ShoppingResponseID" minOccurs="0"/>
 *         &lt;xs:element name="Services" minOccurs="0">
 *           &lt;!-- Reference to inner class Services -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="DataLists" minOccurs="0">
 *           &lt;!-- Reference to inner class DataLists -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:BagListResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class BaggageListRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private ProcessingResultType processing;
    private BagListResParamsType parameters;
    private ShoppingResponseIDType shoppingResponseID;
    private Services services;
    private DataLists dataLists;
    private BagListResMetadataType metadata;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Processing' element value.
     * 
     * @return value
     */
    public ProcessingResultType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value.
     * 
     * @param processing
     */
    public void setProcessing(ProcessingResultType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public BagListResParamsType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Search Result Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(BagListResParamsType parameters) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.parameters = parameters;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.shoppingResponseID = shoppingResponseID;
    }

    /** 
     * Get the 'Services' element value.
     * 
     * @return value
     */
    public Services getServices() {
        return services;
    }

    /** 
     * Set the 'Services' element value.
     * 
     * @param services
     */
    public void setServices(Services services) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.services = services;
    }

    /** 
     * Get the 'DataLists' element value.
     * 
     * @return value
     */
    public DataLists getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value.
     * 
     * @param dataLists
     */
    public void setDataLists(DataLists dataLists) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public BagListResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(BagListResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Service(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Services" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ServiceDetailType" name="Service" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Services implements Serializable
    {
        private List<ServiceDetailType> serviceList = new ArrayList<ServiceDetailType>();

        /** 
         * Get the list of 'Service' element items. Service detail.
         * 
         * @return list
         */
        public List<ServiceDetailType> getServiceList() {
            return serviceList;
        }

        /** 
         * Set the list of 'Service' element items. Service detail.
         * 
         * @param list
         */
        public void setServiceList(List<ServiceDetailType> list) {
            serviceList = list;
        }
    }
    /** 
     * Data Lists(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataLists" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:DataListType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="PassengerList" minOccurs="0">
     *             &lt;!-- Reference to inner class PassengerList -->
     *           &lt;/xs:element>
     *           &lt;xs:element name="ContactList" minOccurs="0">
     *             &lt;!-- Reference to inner class ContactList -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DataLists extends DataListType implements Serializable
    {
        private PassengerList passengerList;
        private ContactList contactList;

        /** 
         * Get the 'PassengerList' element value.
         * 
         * @return value
         */
        public PassengerList getPassengerList() {
            return passengerList;
        }

        /** 
         * Set the 'PassengerList' element value.
         * 
         * @param passengerList
         */
        public void setPassengerList(PassengerList passengerList) {
            this.passengerList = passengerList;
        }

        /** 
         * Get the 'ContactList' element value.
         * 
         * @return value
         */
        public ContactList getContactList() {
            return contactList;
        }

        /** 
         * Set the 'ContactList' element value.
         * 
         * @param contactList
         */
        public void setContactList(ContactList contactList) {
            this.contactList = contactList;
        }
        /** 
         * Passenger data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:PassengerType" name="Passenger" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerList implements Serializable
        {
            private List<PassengerType> passengerList = new ArrayList<PassengerType>();

            /** 
             * Get the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @return list
             */
            public List<PassengerType> getPassengerList() {
                return passengerList;
            }

            /** 
             * Set the list of 'Passenger' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship.
             * 
             * @param list
             */
            public void setPassengerList(List<PassengerType> list) {
                passengerList = list;
            }
        }
        /** 
         * Contact data list definition.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ContactInformationType" name="ContactInformation" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContactList implements Serializable
        {
            private List<ContactInformationType> contactInformationList = new ArrayList<ContactInformationType>();

            /** 
             * Get the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @return list
             */
            public List<ContactInformationType> getContactInformationList() {
                return contactInformationList;
            }

            /** 
             * Set the list of 'ContactInformation' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
             * 
             * @param list
             */
            public void setContactInformationList(
                    List<ContactInformationType> list) {
                contactInformationList = list;
            }
        }
    }
}
