
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * BAGGAGE PRICING Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggagePricingQualifierType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BaggageOption" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="RequestAction" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OptionalCharges" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="FixedPrePaidInd"/>
 *   &lt;xs:attribute type="xs:string" name="CommercialAgreementID"/>
 *   &lt;xs:attribute type="xs:boolean" name="DeferralInd"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:boolean" name="IncludeSettlementInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BaggagePricingQualifierType implements Serializable
{
    private List<String> baggageOptionList = new ArrayList<String>();
    private String requestAction;
    private String optionalCharges;
    private Boolean fixedPrePaidInd;
    private String commercialAgreementID;
    private Boolean deferralInd;
    private String refs;
    private Boolean includeSettlementInd;

    /** 
     * Get the list of 'BaggageOption' element items. Qualifier to specific the type of Baggage pricing.
    Example: Checked Bag

    Encoding Scheme: IATA PADIS Code List for data element OPT.
     * 
     * @return list
     */
    public List<String> getBaggageOptionList() {
        return baggageOptionList;
    }

    /** 
     * Set the list of 'BaggageOption' element items. Qualifier to specific the type of Baggage pricing.
    Example: Checked Bag

    Encoding Scheme: IATA PADIS Code List for data element OPT.
     * 
     * @param list
     */
    public void setBaggageOptionList(List<String> list) {
        baggageOptionList = list;
    }

    /** 
     * Get the 'RequestAction' element value. Request action. Example: 131 (DISPLAY ONLY)

    Encoding Scheme: IATA PADIS Code List for data element 1225
     * 
     * @return value
     */
    public String getRequestAction() {
        return requestAction;
    }

    /** 
     * Set the 'RequestAction' element value. Request action. Example: 131 (DISPLAY ONLY)

    Encoding Scheme: IATA PADIS Code List for data element 1225
     * 
     * @param requestAction
     */
    public void setRequestAction(String requestAction) {
        this.requestAction = requestAction;
    }

    /** 
     * Get the 'OptionalCharges' element value. Allowance catalog requested. Example: C (CATALOG ONLY)
     * 
     * @return value
     */
    public String getOptionalCharges() {
        return optionalCharges;
    }

    /** 
     * Set the 'OptionalCharges' element value. Allowance catalog requested. Example: C (CATALOG ONLY)
     * 
     * @param optionalCharges
     */
    public void setOptionalCharges(String optionalCharges) {
        this.optionalCharges = optionalCharges;
    }

    /** 
     * Get the 'FixedPrePaidInd' attribute value. Allows POA to tell the ORA if the ORA may alter the POA’s pre-paid baggage charges

    If True: prepaid charge may NOT be altered
    If False: prepaid charge MAY be altered
     * 
     * @return value
     */
    public Boolean getFixedPrePaidInd() {
        return fixedPrePaidInd;
    }

    /** 
     * Set the 'FixedPrePaidInd' attribute value. Allows POA to tell the ORA if the ORA may alter the POA’s pre-paid baggage charges

    If True: prepaid charge may NOT be altered
    If False: prepaid charge MAY be altered
     * 
     * @param fixedPrePaidInd
     */
    public void setFixedPrePaidInd(Boolean fixedPrePaidInd) {
        this.fixedPrePaidInd = fixedPrePaidInd;
    }

    /** 
     * Get the 'CommercialAgreementID' attribute value. Bi-lateral agreement identifier, i.e. - baggage cost, Baggage Determining Carrier, etc.
     * 
     * @return value
     */
    public String getCommercialAgreementID() {
        return commercialAgreementID;
    }

    /** 
     * Set the 'CommercialAgreementID' attribute value. Bi-lateral agreement identifier, i.e. - baggage cost, Baggage Determining Carrier, etc.
     * 
     * @param commercialAgreementID
     */
    public void setCommercialAgreementID(String commercialAgreementID) {
        this.commercialAgreementID = commercialAgreementID;
    }

    /** 
     * Get the 'DeferralInd' attribute value. If True, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation.
     * 
     * @return value
     */
    public Boolean getDeferralInd() {
        return deferralInd;
    }

    /** 
     * Set the 'DeferralInd' attribute value. If True, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation.
     * 
     * @param deferralInd
     */
    public void setDeferralInd(Boolean deferralInd) {
        this.deferralInd = deferralInd;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'IncludeSettlementInd' attribute value. If True, POA is requested to return the settlement value for the baggage.
     * 
     * @return value
     */
    public Boolean getIncludeSettlementInd() {
        return includeSettlementInd;
    }

    /** 
     * Set the 'IncludeSettlementInd' attribute value. If True, POA is requested to return the settlement value for the baggage.
     * 
     * @param includeSettlementInd
     */
    public void setIncludeSettlementInd(Boolean includeSettlementInd) {
        this.includeSettlementInd = includeSettlementInd;
    }
}
