
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * BAGGAGE QUERY Metadata definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageQueryMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="TicketIssuePlace" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="TicketIssueCountry" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PassengerCount" minOccurs="0"/>
 *         &lt;xs:element type="ns:CurrencyAmountOptType" name="TotalPrice" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageQueryMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String ticketIssuePlace;
    private String ticketIssueCountry;
    private String passengerCount;
    private CurrencyAmountOptType totalPrice;

    /** 
     * Get the 'TicketIssuePlace' element value. Ticket issue location.
    Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.
    http://www.iata.org/publications/Pages/code-search.aspx
     * 
     * @return value
     */
    public String getTicketIssuePlace() {
        return ticketIssuePlace;
    }

    /** 
     * Set the 'TicketIssuePlace' element value. Ticket issue location.
    Example: MIAFor maximum interoperability, it is recommended that IATA (three character) Airport/ City Code values be used. Use an IATA code or a proprietary string value.
    http://www.iata.org/publications/Pages/code-search.aspx
     * 
     * @param ticketIssuePlace
     */
    public void setTicketIssuePlace(String ticketIssuePlace) {
        this.ticketIssuePlace = ticketIssuePlace;
    }

    /** 
     * Get the 'TicketIssueCountry' element value. Ticket issue country.
    Example: CA
     * 
     * @return value
     */
    public String getTicketIssueCountry() {
        return ticketIssueCountry;
    }

    /** 
     * Set the 'TicketIssueCountry' element value. Ticket issue country.
    Example: CA
     * 
     * @param ticketIssueCountry
     */
    public void setTicketIssueCountry(String ticketIssueCountry) {
        this.ticketIssueCountry = ticketIssueCountry;
    }

    /** 
     * Get the 'PassengerCount' element value. Total number of passengers of all types for the entire itinerary. Example: 4
     * 
     * @return value
     */
    public String getPassengerCount() {
        return passengerCount;
    }

    /** 
     * Set the 'PassengerCount' element value. Total number of passengers of all types for the entire itinerary. Example: 4
     * 
     * @param passengerCount
     */
    public void setPassengerCount(String passengerCount) {
        this.passengerCount = passengerCount;
    }

    /** 
     * Get the 'TotalPrice' element value. Total price for the entire itinerary for all passengers of all types. Example: 320000
     * 
     * @return value
     */
    public CurrencyAmountOptType getTotalPrice() {
        return totalPrice;
    }

    /** 
     * Set the 'TotalPrice' element value. Total price for the entire itinerary for all passengers of all types. Example: 320000
     * 
     * @param totalPrice
     */
    public void setTotalPrice(CurrencyAmountOptType totalPrice) {
        this.totalPrice = totalPrice;
    }
}
