
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BeforeOrAfterListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Before"/>
 *     &lt;xs:enumeration value="After"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BeforeOrAfterListType implements Serializable {
    BEFORE("Before"), AFTER("After");
    private final String value;

    private BeforeOrAfterListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BeforeOrAfterListType convert(String value) {
        for (BeforeOrAfterListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
