
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Best Pricing Method Preference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BestPricingPreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BestPricingOption">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class BestPricingOption -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BestPricingPreferencesType implements Serializable
{
    private BestPricingOption bestPricingOption;

    /** 
     * Get the 'BestPricingOption' element value. Best Available Fare Pricing Method.
    Examples:
    Y (BEST FARE IN SAME CABIN CLASS)
    C (BEST FARE ACROSS ALL CABIN CLASSES)
    N (PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS)
     * 
     * @return value
     */
    public BestPricingOption getBestPricingOption() {
        return bestPricingOption;
    }

    /** 
     * Set the 'BestPricingOption' element value. Best Available Fare Pricing Method.
    Examples:
    Y (BEST FARE IN SAME CABIN CLASS)
    C (BEST FARE ACROSS ALL CABIN CLASSES)
    N (PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS)
     * 
     * @param bestPricingOption
     */
    public void setBestPricingOption(BestPricingOption bestPricingOption) {
        this.bestPricingOption = bestPricingOption;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Y"/>
     *     &lt;xs:enumeration value="C"/>
     *     &lt;xs:enumeration value="N"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum BestPricingOption implements Serializable {
        /** 
         * BEST FARE IN SAME CABIN CLASS
         */
        Y, /** 
            * BEST FARE ACROSS ALL CABIN CLASSES
            */
        C, /** 
            * PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS
            */
        N
    }
}
