
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offer/ Offer Item: BILATERAL (Implementer-Assigned) TIME LIMITS definition.

 Bilateral Time Limit value.
 Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

 Note: This is a bilaterally-agreed upon time limit that is not included in the NDC XML Specification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BilateralTimeLimitsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BilateralTimeLimit" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class BilateralTimeLimit -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BilateralTimeLimitsType implements Serializable
{
    private List<BilateralTimeLimit> bilateralTimeLimitList = new ArrayList<BilateralTimeLimit>();

    /** 
     * Get the list of 'BilateralTimeLimit' element items.
     * 
     * @return list
     */
    public List<BilateralTimeLimit> getBilateralTimeLimitList() {
        return bilateralTimeLimitList;
    }

    /** 
     * Set the list of 'BilateralTimeLimit' element items.
     * 
     * @param list
     */
    public void setBilateralTimeLimitList(List<BilateralTimeLimit> list) {
        bilateralTimeLimitList = list;
    }
    /** 
     * Bilateral Time Limit value.
    Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

    Note: This is a bilaterally-agreed upon time limit that is not included in the NDC XML Specification.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BilateralTimeLimit" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Name"/>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:AttrCoreDateGrpType"/>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class BilateralTimeLimit implements Serializable
    {
        private String name;
        private String description;
        private AttrCoreDateGrpType attrCoreDateGrpType;
        private String refs;

        /** 
         * Get the 'Name' element value. Bilateral Time Limit name.  Example: Other Time Limit
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Bilateral Time Limit name.  Example: Other Time Limit
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'Description' element value. Bilateral Time Limit name.  Example: Other Time Limit
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Bilateral Time Limit name.  Example: Other Time Limit
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }

        /** 
         * Get the 'AttrCoreDateGrpType' attributeGroup value.
         * 
         * @return value
         */
        public AttrCoreDateGrpType getAttrCoreDateGrpType() {
            return attrCoreDateGrpType;
        }

        /** 
         * Set the 'AttrCoreDateGrpType' attributeGroup value.
         * 
         * @param attrCoreDateGrpType
         */
        public void setAttrCoreDateGrpType(
                AttrCoreDateGrpType attrCoreDateGrpType) {
            this.attrCoreDateGrpType = attrCoreDateGrpType;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
