
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Booking Reference definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingReferenceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ID"/>
 *     &lt;xs:choice>
 *       &lt;xs:element name="AirlineID">
 *         &lt;xs:complexType>
 *           &lt;xs:complexContent>
 *             &lt;xs:extension base="ns:AirlineID_Type">
 *               &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:complexContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="OtherID">
 *         &lt;xs:complexType>
 *           &lt;xs:simpleContent>
 *             &lt;xs:extension base="xs:string">
 *               &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *               &lt;xs:attribute type="xs:string" use="optional" name="ObjectMetaReferences"/>
 *               &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
 *             &lt;/xs:extension>
 *           &lt;/xs:simpleContent>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BookingReferenceType implements Serializable
{
    private String type;
    private String ID;
    private int choiceSelect = -1;
    private static final int AIRLINE_ID_CHOICE = 0;
    private static final int OTHER_ID_CHOICE = 1;
    private AirlineIDType airlineIDAirlineIDType;
    private String airlineIDName;
    private String otherIDString;
    private String otherIDRefs;
    private String otherIDObjectMetaReferences;
    private String otherIDName;
    private String refs;

    /** 
     * Get the 'Type' element value. Booking Reference Type. Example: 6 (Passenger confirmation number) Encoding Scheme: IATA Padis Codeset - List for data element [1153] Reference Qualifier
                
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Booking Reference Type. Example: 6 (Passenger confirmation number) Encoding Scheme: IATA Padis Codeset - List for data element [1153] Reference Qualifier
                
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'ID' element value. Existing Booking Reference ID. Example: R1A3SK
     * 
     * @return value
     */
    public String getID() {
        return ID;
    }

    /** 
     * Set the 'ID' element value. Existing Booking Reference ID. Example: R1A3SK
     * 
     * @param ID
     */
    public void setID(String ID) {
        this.ID = ID;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AirlineID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineID() {
        return choiceSelect == AIRLINE_ID_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public AirlineIDType getAirlineIDAirlineIDType() {
        return airlineIDAirlineIDType;
    }

    /** 
     * Set the extension value.
     * 
     * @param airlineIDAirlineIDType
     */
    public void setAirlineIDAirlineIDType(AirlineIDType airlineIDAirlineIDType) {
        setChoiceSelect(AIRLINE_ID_CHOICE);
        this.airlineIDAirlineIDType = airlineIDAirlineIDType;
    }

    /** 
     * Get the 'Name' attribute value. Name. Example: British Airways
     * 
     * @return value
     */
    public String getAirlineIDName() {
        return airlineIDName;
    }

    /** 
     * Set the 'Name' attribute value. Name. Example: British Airways
     * 
     * @param airlineIDName
     */
    public void setAirlineIDName(String airlineIDName) {
        setChoiceSelect(AIRLINE_ID_CHOICE);
        this.airlineIDName = airlineIDName;
    }

    /** 
     * Check if OtherID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherID() {
        return choiceSelect == OTHER_ID_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getOtherIDString() {
        return otherIDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param otherIDString
     */
    public void setOtherIDString(String otherIDString) {
        setChoiceSelect(OTHER_ID_CHOICE);
        this.otherIDString = otherIDString;
    }

    /** 
     * Get the 'refs' attribute value. 
                            Object association(s) between this object and any other object or metadata instance(s).
                          
     * 
     * @return value
     */
    public String getOtherIDRefs() {
        return otherIDRefs;
    }

    /** 
     * Set the 'refs' attribute value. 
                            Object association(s) between this object and any other object or metadata instance(s).
                          
     * 
     * @param otherIDRefs
     */
    public void setOtherIDRefs(String otherIDRefs) {
        setChoiceSelect(OTHER_ID_CHOICE);
        this.otherIDRefs = otherIDRefs;
    }

    /** 
     * Get the 'ObjectMetaReferences' attribute value. 
                            Object Metadata Association(s). Example: meta1 meta3
                          
     * 
     * @return value
     */
    public String getOtherIDObjectMetaReferences() {
        return otherIDObjectMetaReferences;
    }

    /** 
     * Set the 'ObjectMetaReferences' attribute value. 
                            Object Metadata Association(s). Example: meta1 meta3
                          
     * 
     * @param otherIDObjectMetaReferences
     */
    public void setOtherIDObjectMetaReferences(
            String otherIDObjectMetaReferences) {
        setChoiceSelect(OTHER_ID_CHOICE);
        this.otherIDObjectMetaReferences = otherIDObjectMetaReferences;
    }

    /** 
     * Get the 'Name' attribute value. Entity Name.
     * 
     * @return value
     */
    public String getOtherIDName() {
        return otherIDName;
    }

    /** 
     * Set the 'Name' attribute value. Entity Name.
     * 
     * @param otherIDName
     */
    public void setOtherIDName(String otherIDName) {
        setChoiceSelect(OTHER_ID_CHOICE);
        this.otherIDName = otherIDName;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
