
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Class of Service Optional Associations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="COS_AssocListItemType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Equipment"/>
 *     &lt;xs:enumeration value="FlightGroup"/>
 *     &lt;xs:enumeration value="FlightOriginDestination"/>
 *     &lt;xs:enumeration value="FlightSegment"/>
 *     &lt;xs:enumeration value="MediaGroup"/>
 *     &lt;xs:enumeration value="MediaItem"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum COSAssocListItemType implements Serializable {
    EQUIPMENT("Equipment"), FLIGHT_GROUP("FlightGroup"), FLIGHT_ORIGIN_DESTINATION(
            "FlightOriginDestination"), FLIGHT_SEGMENT("FlightSegment"), MEDIA_GROUP(
            "MediaGroup"), MEDIA_ITEM("MediaItem");
    private final String value;

    private COSAssocListItemType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static COSAssocListItemType convert(String value) {
        for (COSAssocListItemType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
