
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for Cabin Preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinPreferencesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:CabinType" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CabinPreferencesType implements Serializable
{
    private List<CabinType> cabinTypeList = new ArrayList<CabinType>();
    private String refs;

    /** 
     * Get the list of 'CabinType' element items.
     * 
     * @return list
     */
    public List<CabinType> getCabinTypeList() {
        return cabinTypeList;
    }

    /** 
     * Set the list of 'CabinType' element items.
     * 
     * @param list
     */
    public void setCabinTypeList(List<CabinType> list) {
        cabinTypeList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
