
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Used to indicate payment in cash.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cash">
 *   &lt;xs:complexType>
 *     &lt;xs:attribute type="xs:boolean" use="optional" name="CashInd"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Cash implements Serializable
{
    private Boolean cashInd;

    /** 
     * Get the 'CashInd' attribute value. When true, payment is being made in cash.
     * 
     * @return value
     */
    public Boolean getCashInd() {
        return cashInd;
    }

    /** 
     * Set the 'CashInd' attribute value. When true, payment is being made in cash.
     * 
     * @param cashInd
     */
    public void setCashInd(Boolean cashInd) {
        this.cashInd = cashInd;
    }
}
