
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * CASH Payment Method definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CashMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TerminalID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ReceiptID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:AgentUserID" minOccurs="0"/>
 *     &lt;xs:element name="Address" minOccurs="0">
 *       &lt;!-- Reference to inner class Address -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CashMethodType implements Serializable
{
    private CurrencyAmountOptType amount;
    private String terminalID;
    private String receiptID;
    private AgentUserIDType agentUserID;
    private Address address;
    private String refs;

    /** 
     * Get the 'Amount' element value. Cash Amount. Example: 67.95
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Cash Amount. Example: 67.95
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'TerminalID' element value. Terminal ID where cash was collected. Example: QP776611
     * 
     * @return value
     */
    public String getTerminalID() {
        return terminalID;
    }

    /** 
     * Set the 'TerminalID' element value. Terminal ID where cash was collected. Example: QP776611
     * 
     * @param terminalID
     */
    public void setTerminalID(String terminalID) {
        this.terminalID = terminalID;
    }

    /** 
     * Get the 'ReceiptID' element value. Cash receipt ID. Example: 121717H47S
     * 
     * @return value
     */
    public String getReceiptID() {
        return receiptID;
    }

    /** 
     * Set the 'ReceiptID' element value. Cash receipt ID. Example: 121717H47S
     * 
     * @param receiptID
     */
    public void setReceiptID(String receiptID) {
        this.receiptID = receiptID;
    }

    /** 
     * Get the 'AgentUserID' element value. Agent ID that collected the cash. Example: TOM123
     * 
     * @return value
     */
    public AgentUserIDType getAgentUserID() {
        return agentUserID;
    }

    /** 
     * Set the 'AgentUserID' element value. Agent ID that collected the cash. Example: TOM123
     * 
     * @param agentUserID
     */
    public void setAgentUserID(AgentUserIDType agentUserID) {
        this.agentUserID = agentUserID;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Location where cash was collected.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns:SimpleAddress"/>
     *       &lt;xs:element ref="ns:StructuredAddress"/>
     *       &lt;xs:element ref="ns:PaymentAddress"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Address implements Serializable
    {
        private int addressSelect = -1;
        private static final int SIMPLE_ADDRESS_CHOICE = 0;
        private static final int STRUCTURED_ADDRESS_CHOICE = 1;
        private static final int PAYMENT_ADDRESS_CHOICE = 2;
        private SimpleAddrType simpleAddress;
        private StructuredAddress structuredAddress;
        private PaymentAddrType paymentAddress;

        private void setAddressSelect(int choice) {
            if (addressSelect == -1) {
                addressSelect = choice;
            } else if (addressSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearAddressSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearAddressSelect() {
            addressSelect = -1;
        }

        /** 
         * Check if SimpleAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSimpleAddress() {
            return addressSelect == SIMPLE_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'SimpleAddress' element value.
         * 
         * @return value
         */
        public SimpleAddrType getSimpleAddress() {
            return simpleAddress;
        }

        /** 
         * Set the 'SimpleAddress' element value.
         * 
         * @param simpleAddress
         */
        public void setSimpleAddress(SimpleAddrType simpleAddress) {
            setAddressSelect(SIMPLE_ADDRESS_CHOICE);
            this.simpleAddress = simpleAddress;
        }

        /** 
         * Check if StructuredAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStructuredAddress() {
            return addressSelect == STRUCTURED_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'StructuredAddress' element value.
         * 
         * @return value
         */
        public StructuredAddress getStructuredAddress() {
            return structuredAddress;
        }

        /** 
         * Set the 'StructuredAddress' element value.
         * 
         * @param structuredAddress
         */
        public void setStructuredAddress(StructuredAddress structuredAddress) {
            setAddressSelect(STRUCTURED_ADDRESS_CHOICE);
            this.structuredAddress = structuredAddress;
        }

        /** 
         * Check if PaymentAddress is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPaymentAddress() {
            return addressSelect == PAYMENT_ADDRESS_CHOICE;
        }

        /** 
         * Get the 'PaymentAddress' element value.
         * 
         * @return value
         */
        public PaymentAddrType getPaymentAddress() {
            return paymentAddress;
        }

        /** 
         * Set the 'PaymentAddress' element value.
         * 
         * @param paymentAddress
         */
        public void setPaymentAddress(PaymentAddrType paymentAddress) {
            setAddressSelect(PAYMENT_ADDRESS_CHOICE);
            this.paymentAddress = paymentAddress;
        }
    }
}
