
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * CHECKED BAG ALLOWANCE defiition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedBagAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CheckedBag" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class CheckedBag -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CheckedBagAllowanceType implements Serializable
{
    private List<CheckedBag> checkedBagList = new ArrayList<CheckedBag>();

    /** 
     * Get the list of 'CheckedBag' element items.
     * 
     * @return list
     */
    public List<CheckedBag> getCheckedBagList() {
        return checkedBagList;
    }

    /** 
     * Set the list of 'CheckedBag' element items.
     * 
     * @param list
     */
    public void setCheckedBagList(List<CheckedBag> list) {
        checkedBagList = list;
    }
    /** 
     * Checked Bag Allowance detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckedBag" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:WeightAllowance" minOccurs="0"/>
     *       &lt;xs:element ref="ns:PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element ref="ns:DimensionAllowance" minOccurs="0"/>
     *       &lt;xs:element ref="ns:AllowanceDescription" minOccurs="0"/>
     *       &lt;xs:element type="ns:BaggageDeterminingCarrierType" name="BaggageDeterminingCarrier" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="BDC_AnalysisResult" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class CheckedBag implements Serializable
    {
        private WeightAllowance weightAllowance;
        private List<BagAllowancePieceType> pieceAllowanceList = new ArrayList<BagAllowancePieceType>();
        private BagAllowanceDimensionType dimensionAllowance;
        private BagAllowanceDescType allowanceDescription;
        private BaggageDeterminingCarrierType baggageDeterminingCarrier;
        private String BDCAnalysisResult;
        private String refs;

        /** 
         * Get the 'WeightAllowance' element value.
         * 
         * @return value
         */
        public WeightAllowance getWeightAllowance() {
            return weightAllowance;
        }

        /** 
         * Set the 'WeightAllowance' element value.
         * 
         * @param weightAllowance
         */
        public void setWeightAllowance(WeightAllowance weightAllowance) {
            this.weightAllowance = weightAllowance;
        }

        /** 
         * Get the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
         * 
         * @return list
         */
        public List<BagAllowancePieceType> getPieceAllowanceList() {
            return pieceAllowanceList;
        }

        /** 
         * Set the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
         * 
         * @param list
         */
        public void setPieceAllowanceList(List<BagAllowancePieceType> list) {
            pieceAllowanceList = list;
        }

        /** 
         * Get the 'DimensionAllowance' element value.
         * 
         * @return value
         */
        public BagAllowanceDimensionType getDimensionAllowance() {
            return dimensionAllowance;
        }

        /** 
         * Set the 'DimensionAllowance' element value.
         * 
         * @param dimensionAllowance
         */
        public void setDimensionAllowance(
                BagAllowanceDimensionType dimensionAllowance) {
            this.dimensionAllowance = dimensionAllowance;
        }

        /** 
         * Get the 'AllowanceDescription' element value.
         * 
         * @return value
         */
        public BagAllowanceDescType getAllowanceDescription() {
            return allowanceDescription;
        }

        /** 
         * Set the 'AllowanceDescription' element value.
         * 
         * @param allowanceDescription
         */
        public void setAllowanceDescription(
                BagAllowanceDescType allowanceDescription) {
            this.allowanceDescription = allowanceDescription;
        }

        /** 
         * Get the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
         * 
         * @return value
         */
        public BaggageDeterminingCarrierType getBaggageDeterminingCarrier() {
            return baggageDeterminingCarrier;
        }

        /** 
         * Set the 'BaggageDeterminingCarrier' element value. Baggage Determining Carrier as defined in resolution 722 (f), and who’s baggage rules apply.
         * 
         * @param baggageDeterminingCarrier
         */
        public void setBaggageDeterminingCarrier(
                BaggageDeterminingCarrierType baggageDeterminingCarrier) {
            this.baggageDeterminingCarrier = baggageDeterminingCarrier;
        }

        /** 
         * Get the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code.

        Encoding Scheme: IATA PADIS Code List for data element RES.
         * 
         * @return value
         */
        public String getBDCAnalysisResult() {
            return BDCAnalysisResult;
        }

        /** 
         * Set the 'BDC_AnalysisResult' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code.

        Encoding Scheme: IATA PADIS Code List for data element RES.
         * 
         * @param BDCAnalysisResult
         */
        public void setBDCAnalysisResult(String BDCAnalysisResult) {
            this.BDCAnalysisResult = BDCAnalysisResult;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
    }
}
