
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for PADIS/ CODESET Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodesetMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Source" minOccurs="0">
 *           &lt;!-- Reference to inner class Source -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="OtherLanguage" minOccurs="0">
 *           &lt;!-- Reference to inner class OtherLanguage -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CodesetMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private Source source;
    private OtherLanguage otherLanguage;

    /** 
     * Get the 'Source' element value.
     * 
     * @return value
     */
    public Source getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value.
     * 
     * @param source
     */
    public void setSource(Source source) {
        this.source = source;
    }

    /** 
     * Get the 'OtherLanguage' element value.
     * 
     * @return value
     */
    public OtherLanguage getOtherLanguage() {
        return otherLanguage;
    }

    /** 
     * Set the 'OtherLanguage' element value.
     * 
     * @param otherLanguage
     */
    public void setOtherLanguage(OtherLanguage otherLanguage) {
        this.otherLanguage = otherLanguage;
    }
    /** 
     * Codeset Source.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Source" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="OwnerID" minOccurs="0">
     *         &lt;!-- Reference to inner class OwnerID -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="File" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Version" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Source implements Serializable
    {
        private OwnerID ownerID;
        private String file;
        private String version;

        /** 
         * Get the 'OwnerID' element value.
         * 
         * @return value
         */
        public OwnerID getOwnerID() {
            return ownerID;
        }

        /** 
         * Set the 'OwnerID' element value.
         * 
         * @param ownerID
         */
        public void setOwnerID(OwnerID ownerID) {
            this.ownerID = ownerID;
        }

        /** 
         * Get the 'File' element value. Codeset file or resource name. Example: PADIS Codeset
         * 
         * @return value
         */
        public String getFile() {
            return file;
        }

        /** 
         * Set the 'File' element value. Codeset file or resource name. Example: PADIS Codeset
         * 
         * @param file
         */
        public void setFile(String file) {
            this.file = file;
        }

        /** 
         * Get the 'Version' element value. Codeset version. Example: 14
         * 
         * @return value
         */
        public String getVersion() {
            return version;
        }

        /** 
         * Set the 'Version' element value. Codeset version. Example: 14
         * 
         * @param version
         */
        public void setVersion(String version) {
            this.version = version;
        }
        /** 
         * Owner Entity ID. Example: BA
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OwnerID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OwnerID implements Serializable
        {
            private String string;
            private String name;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Name' attribute value. Owner Name. Example: British Airways
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value. Owner Name. Example: British Airways
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
    /** 
     * Other (alternate) Language Encoding and Code Description.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherLanguage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:LanguageCode"/>
     *       &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OtherLanguage implements Serializable
    {
        private LanguageCodeType languageCode;
        private String description;

        /** 
         * Get the 'LanguageCode' element value.
         * 
         * @return value
         */
        public LanguageCodeType getLanguageCode() {
            return languageCode;
        }

        /** 
         * Set the 'LanguageCode' element value.
         * 
         * @param languageCode
         */
        public void setLanguageCode(LanguageCodeType languageCode) {
            this.languageCode = languageCode;
        }

        /** 
         * Get the 'Description' element value. Codeset table or list name.  Example: Data Element 9972-Originator Type
         * 
         * @return value
         */
        public String getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' element value. Codeset table or list name.  Example: Data Element 9972-Originator Type
         * 
         * @param description
         */
        public void setDescription(String description) {
            this.description = description;
        }
    }
}
