
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * PADIS/ THIRD-PARTY CODESET definition.NDC Capability Model: CODESET

 ============
 Representation(s)
 ============
 • IATA PADIS Encoding
 • Third-Pary Standard Encoding
 • Implementer-Proprietary Encoding

 ============
 Feature(s)
 ============
 • Code value, code definition and code table name may be specified
 • URI to codeset information source may be specified
 • Supports Language Localization (Alternate Language Values)
 • Codeset Source Details (owner, location, etc.) may be specified

 ============
 Metadata
 ============
 • Yes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodesetType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code"/>
 *     &lt;xs:element type="xs:string" name="Definition" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TableName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CodesetType implements Serializable
{
    private String code;
    private String definition;
    private String tableName;
    private String link;
    private String refs;

    /** 
     * Get the 'Code' element value. Code value. Example: 003
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Code value. Example: 003
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Definition' element value. Code Definition. Example: Travel Agency
     * 
     * @return value
     */
    public String getDefinition() {
        return definition;
    }

    /** 
     * Set the 'Definition' element value. Code Definition. Example: Travel Agency
     * 
     * @param definition
     */
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    /** 
     * Get the 'TableName' element value. Code set table name.
     * 
     * @return value
     */
    public String getTableName() {
        return tableName;
    }

    /** 
     * Set the 'TableName' element value. Code set table name.
     * 
     * @param tableName
     */
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /** 
     * Get the 'Link' element value. Codeset location uri.  Example: http://anysite.com/codeset
     * 
     * @return value
     */
    public String getLink() {
        return link;
    }

    /** 
     * Set the 'Link' element value. Codeset location uri.  Example: http://anysite.com/codeset
     * 
     * @param link
     */
    public void setLink(String link) {
        this.link = link;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
