
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactInformationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ContactType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PostalAddressType" name="PostalAddress" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:choice>
 *       &lt;xs:element name="ContactProvided" maxOccurs="unbounded">
 *         &lt;!-- Reference to inner class ContactProvided -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="xs:string" fixed="" name="ContactNotProvided"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns:OtherAddressType" name="OtherAddress" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="xs:string" name="IndividualRef" minOccurs="0"/>
 *       &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="ContactID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContactInformationType implements Serializable
{
    private String contactType;
    private List<PostalAddressType> postalAddressList = new ArrayList<PostalAddressType>();
    private int choiceSelect = -1;
    private static final int CONTACT_PROVIDED_LIST_CHOICE = 0;
    private static final int CONTACT_NOT_PROVIDED_CHOICE = 1;
    private List<ContactProvided> contactProvidedList = new ArrayList<ContactProvided>();
    private String contactNotProvided;
    private List<OtherAddressType> otherAddressList = new ArrayList<OtherAddressType>();
    private int choiceSelect1 = -1;
    private static final int INDIVIDUAL_REF_CHOICE = 0;
    private static final int INDIVIDUAL_CHOICE = 1;
    private String individualRef;
    private IndividualType individual;
    private String contactID;

    /** 
     * Get the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
     * 
     * @return value
     */
    public String getContactType() {
        return contactType;
    }

    /** 
     * Set the 'ContactType' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
     * 
     * @param contactType
     */
    public void setContactType(String contactType) {
        this.contactType = contactType;
    }

    /** 
     * Get the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
     * 
     * @return list
     */
    public List<PostalAddressType> getPostalAddressList() {
        return postalAddressList;
    }

    /** 
     * Set the list of 'PostalAddress' element items. The address used for postal service. Examples are post office boxes address, postal physical address, postal code
     * 
     * @param list
     */
    public void setPostalAddressList(List<PostalAddressType> list) {
        postalAddressList = list;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ContactProvidedList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContactProvidedList() {
        return choiceSelect == CONTACT_PROVIDED_LIST_CHOICE;
    }

    /** 
     * Get the list of 'ContactProvided' element items.
     * 
     * @return list
     */
    public List<ContactProvided> getContactProvidedList() {
        return contactProvidedList;
    }

    /** 
     * Set the list of 'ContactProvided' element items.
     * 
     * @param list
     */
    public void setContactProvidedList(List<ContactProvided> list) {
        setChoiceSelect(CONTACT_PROVIDED_LIST_CHOICE);
        contactProvidedList = list;
    }

    /** 
     * Check if ContactNotProvided is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContactNotProvided() {
        return choiceSelect == CONTACT_NOT_PROVIDED_CHOICE;
    }

    /** 
     * Get the 'ContactNotProvided' element value. The presence of the empty ContactNotProvided element indicates that the passenger refused to provide contact information.
     * 
     * @return value
     */
    public String getContactNotProvided() {
        return contactNotProvided;
    }

    /** 
     * Set the 'ContactNotProvided' element value. The presence of the empty ContactNotProvided element indicates that the passenger refused to provide contact information.
     * 
     * @param contactNotProvided
     */
    public void setContactNotProvided(String contactNotProvided) {
        setChoiceSelect(CONTACT_NOT_PROVIDED_CHOICE);
        this.contactNotProvided = contactNotProvided;
    }

    /** 
     * Get the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
     * 
     * @return list
     */
    public List<OtherAddressType> getOtherAddressList() {
        return otherAddressList;
    }

    /** 
     * Set the list of 'OtherAddress' element items. Other Contact Method information.   (i.e. social media handle, website, etc.)
     * 
     * @param list
     */
    public void setOtherAddressList(List<OtherAddressType> list) {
        otherAddressList = list;
    }

    private void setChoiceSelect1(int choice) {
        if (choiceSelect1 == -1) {
            choiceSelect1 = choice;
        } else if (choiceSelect1 != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect1() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect1() {
        choiceSelect1 = -1;
    }

    /** 
     * Check if IndividualRef is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifIndividualRef() {
        return choiceSelect1 == INDIVIDUAL_REF_CHOICE;
    }

    /** 
     * Get the 'IndividualRef' element value. Reference to Individual instance(s)
     * 
     * @return value
     */
    public String getIndividualRef() {
        return individualRef;
    }

    /** 
     * Set the 'IndividualRef' element value. Reference to Individual instance(s)
     * 
     * @param individualRef
     */
    public void setIndividualRef(String individualRef) {
        setChoiceSelect1(INDIVIDUAL_REF_CHOICE);
        this.individualRef = individualRef;
    }

    /** 
     * Check if Individual is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifIndividual() {
        return choiceSelect1 == INDIVIDUAL_CHOICE;
    }

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.

     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.

     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        setChoiceSelect1(INDIVIDUAL_CHOICE);
        this.individual = individual;
    }

    /** 
     * Get the 'ContactID' attribute value. Uniquely Identifies a set of Contact Information, within the context of one message.
     * 
     * @return value
     */
    public String getContactID() {
        return contactID;
    }

    /** 
     * Set the 'ContactID' attribute value. Uniquely Identifies a set of Contact Information, within the context of one message.
     * 
     * @param contactID
     */
    public void setContactID(String contactID) {
        this.contactID = contactID;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactProvided" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="ns:EmailAddressType" name="EmailAddress" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:PhoneTypeAIDM" name="Phone" maxOccurs="unbounded"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ContactProvided implements Serializable
    {
        private int contactProvidedListSelect = -1;
        private static final int EMAIL_ADDRESS_LIST_CHOICE = 0;
        private static final int PHONE_LIST_CHOICE = 1;
        private List<EmailAddressType> emailAddressList = new ArrayList<EmailAddressType>();
        private List<PhoneTypeAIDM> phoneList = new ArrayList<PhoneTypeAIDM>();

        private void setContactProvidedListSelect(int choice) {
            if (contactProvidedListSelect == -1) {
                contactProvidedListSelect = choice;
            } else if (contactProvidedListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearContactProvidedListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearContactProvidedListSelect() {
            contactProvidedListSelect = -1;
        }

        /** 
         * Check if EmailAddressList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEmailAddressList() {
            return contactProvidedListSelect == EMAIL_ADDRESS_LIST_CHOICE;
        }

        /** 
         * Get the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
         * 
         * @return list
         */
        public List<EmailAddressType> getEmailAddressList() {
            return emailAddressList;
        }

        /** 
         * Set the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
         * 
         * @param list
         */
        public void setEmailAddressList(List<EmailAddressType> list) {
            setContactProvidedListSelect(EMAIL_ADDRESS_LIST_CHOICE);
            emailAddressList = list;
        }

        /** 
         * Check if PhoneList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPhoneList() {
            return contactProvidedListSelect == PHONE_LIST_CHOICE;
        }

        /** 
         * Get the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

         * 
         * @return list
         */
        public List<PhoneTypeAIDM> getPhoneList() {
            return phoneList;
        }

        /** 
         * Set the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.

         * 
         * @param list
         */
        public void setPhoneList(List<PhoneTypeAIDM> list) {
            setContactProvidedListSelect(PHONE_LIST_CHOICE);
            phoneList = list;
        }
    }
}
