
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * COUNTRY CODE representation.

 Notes:
 1. Examples: US, FR
 2. Encoding Scheme: ISO 3166-1 (two character) Country Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodeType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attributeGroup ref="ns:ObjectPolicyMetaAttrGroup"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CountryCodeType implements Serializable
{
    private String string;
    private ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectPolicyMetaAttrGroup getObjectPolicyMetaAttrGroup() {
        return objectPolicyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @param objectPolicyMetaAttrGroup
     */
    public void setObjectPolicyMetaAttrGroup(
            ObjectPolicyMetaAttrGroup objectPolicyMetaAttrGroup) {
        this.objectPolicyMetaAttrGroup = objectPolicyMetaAttrGroup;
    }
}
