
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * COUNTRY PROXIMITY representation.

 Notes:
 1. This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryProximityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:LocationProximityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:CountryCode"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CountryProximityType extends LocationProximityType implements
    Serializable
{
    private CountryCodeType countryCode;

    /** 
     * Get the 'CountryCode' element value. Country Code. Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @return value
     */
    public CountryCodeType getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Country Code. Examples: US, FR

    Encoding Scheme: ISO 3166-1 (two character) Country Code
     * 
     * @param countryCode
     */
    public void setCountryCode(CountryCodeType countryCode) {
        this.countryCode = countryCode;
    }
}
