
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUNTRY RADIUS QUERY definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryQueryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="CountryCodes" minOccurs="0">
 *       &lt;!-- Reference to inner class CountryCodes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Keywords" minOccurs="0">
 *       &lt;!-- Reference to inner class Keywords -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CountryProximityType" name="Proximity" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PreferenceAttrGroup"/>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CountryQueryType implements Serializable
{
    private CountryCodes countryCodes;
    private Keywords keywords;
    private List<CountryProximityType> proximityList = new ArrayList<CountryProximityType>();
    private PreferenceAttrGroup preferenceAttrGroup;
    private String refs;

    /** 
     * Get the 'CountryCodes' element value.
     * 
     * @return value
     */
    public CountryCodes getCountryCodes() {
        return countryCodes;
    }

    /** 
     * Set the 'CountryCodes' element value.
     * 
     * @param countryCodes
     */
    public void setCountryCodes(CountryCodes countryCodes) {
        this.countryCodes = countryCodes;
    }

    /** 
     * Get the 'Keywords' element value.
     * 
     * @return value
     */
    public Keywords getKeywords() {
        return keywords;
    }

    /** 
     * Set the 'Keywords' element value.
     * 
     * @param keywords
     */
    public void setKeywords(Keywords keywords) {
        this.keywords = keywords;
    }

    /** 
     * Get the list of 'Proximity' element items. COUNTRY PROXIMITY representation.

    Notes: This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
     * 
     * @return list
     */
    public List<CountryProximityType> getProximityList() {
        return proximityList;
    }

    /** 
     * Set the list of 'Proximity' element items. COUNTRY PROXIMITY representation.

    Notes: This contains either the requested maximum distance search radius values -or- the actual Proximity information, which is typically used to specify the results from the named location radius search.
     * 
     * @param list
     */
    public void setProximityList(List<CountryProximityType> list) {
        proximityList = list;
    }

    /** 
     * Get the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public PreferenceAttrGroup getPreferenceAttrGroup() {
        return preferenceAttrGroup;
    }

    /** 
     * Set the 'PreferenceAttrGroup' attributeGroup value.
     * 
     * @param preferenceAttrGroup
     */
    public void setPreferenceAttrGroup(PreferenceAttrGroup preferenceAttrGroup) {
        this.preferenceAttrGroup = preferenceAttrGroup;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Country Code(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryCodes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:CountryCode" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CountryCodes implements Serializable
    {
        private List<CountryCodeType> countryCodeList = new ArrayList<CountryCodeType>();

        /** 
         * Get the list of 'CountryCode' element items. Country Code. Examples: US, FR

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @return list
         */
        public List<CountryCodeType> getCountryCodeList() {
            return countryCodeList;
        }

        /** 
         * Set the list of 'CountryCode' element items. Country Code. Examples: US, FR

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @param list
         */
        public void setCountryCodeList(List<CountryCodeType> list) {
            countryCodeList = list;
        }
    }
    /** 
     * Keyword/ Value Search Criteria.

    Notes: This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. If supported, the technical implementation of this capability is not dictated by this specification.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:KeyWord" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Keywords implements Serializable
    {
        private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

        /** 
         * Get the list of 'KeyWord' element items.
         * 
         * @return list
         */
        public List<KeyWordType> getKeyWordList() {
            return keyWordList;
        }

        /** 
         * Set the list of 'KeyWord' element items.
         * 
         * @param list
         */
        public void setKeyWordList(List<KeyWordType> list) {
            keyWordList = list;
        }
    }
}
