
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * COUPON BOOKING/ SERVICING AGENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponAgentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element name="ID">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="ObjectMetaReferences"/>
 *             &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponAgentType implements Serializable
{
    private String type;
    private String IDString;
    private String IDRefs;
    private String IDObjectMetaReferences;
    private String IDName;

    /** 
     * Get the 'Type' element value. Agency/ Agent Identification Type. Example: 706 (IATA agency numeric code)

    Encoding Scheme: IATA Padis Codeset - List for data element 9893 (Identification Type, coded)
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Agency/ Agent Identification Type. Example: 706 (IATA agency numeric code)

    Encoding Scheme: IATA Padis Codeset - List for data element 9893 (Identification Type, coded)
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getIDString() {
        return IDString;
    }

    /** 
     * Set the extension value.
     * 
     * @param IDString
     */
    public void setIDString(String IDString) {
        this.IDString = IDString;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getIDRefs() {
        return IDRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param IDRefs
     */
    public void setIDRefs(String IDRefs) {
        this.IDRefs = IDRefs;
    }

    /** 
     * Get the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
     * 
     * @return value
     */
    public String getIDObjectMetaReferences() {
        return IDObjectMetaReferences;
    }

    /** 
     * Set the 'ObjectMetaReferences' attribute value. Object Metadata Association(s). Example: meta1 meta3
     * 
     * @param IDObjectMetaReferences
     */
    public void setIDObjectMetaReferences(String IDObjectMetaReferences) {
        this.IDObjectMetaReferences = IDObjectMetaReferences;
    }

    /** 
     * Get the 'Name' attribute value. Entity Name.
     * 
     * @return value
     */
    public String getIDName() {
        return IDName;
    }

    /** 
     * Set the 'Name' attribute value. Entity Name.
     * 
     * @param IDName
     */
    public void setIDName(String IDName) {
        this.IDName = IDName;
    }
}
