
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUPON-RELATED ORDER REFERENCE definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponOrderKeyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:OrderID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:OrderItemID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:OfferItemID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ServiceID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
 *     &lt;xs:element ref="ns:ShoppingResponseID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponOrderKeyType implements Serializable
{
    private OrderIDType orderID;
    private OrderItemID orderItemID;
    private OfferItemID offerItemID;
    private List<ServiceIDType> serviceIDList = new ArrayList<ServiceIDType>();
    private BookingReferenceType bookingReference;
    private ShoppingResponseIDType shoppingResponseID;

    /** 
     * Get the 'OrderID' element value.
     * 
     * @return value
     */
    public OrderIDType getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value.
     * 
     * @param orderID
     */
    public void setOrderID(OrderIDType orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'OrderItemID' element value.
     * 
     * @return value
     */
    public OrderItemID getOrderItemID() {
        return orderItemID;
    }

    /** 
     * Set the 'OrderItemID' element value.
     * 
     * @param orderItemID
     */
    public void setOrderItemID(OrderItemID orderItemID) {
        this.orderItemID = orderItemID;
    }

    /** 
     * Get the 'OfferItemID' element value.
     * 
     * @return value
     */
    public OfferItemID getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(OfferItemID offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the list of 'ServiceID' element items.
     * 
     * @return list
     */
    public List<ServiceIDType> getServiceIDList() {
        return serviceIDList;
    }

    /** 
     * Set the list of 'ServiceID' element items.
     * 
     * @param list
     */
    public void setServiceIDList(List<ServiceIDType> list) {
        serviceIDList = list;
    }

    /** 
     * Get the 'BookingReference' element value.
     * 
     * @return value
     */
    public BookingReferenceType getBookingReference() {
        return bookingReference;
    }

    /** 
     * Set the 'BookingReference' element value.
     * 
     * @param bookingReference
     */
    public void setBookingReference(BookingReferenceType bookingReference) {
        this.bookingReference = bookingReference;
    }

    /** 
     * Get the 'ShoppingResponseID' element value.
     * 
     * @return value
     */
    public ShoppingResponseIDType getShoppingResponseID() {
        return shoppingResponseID;
    }

    /** 
     * Set the 'ShoppingResponseID' element value.
     * 
     * @param shoppingResponseID
     */
    public void setShoppingResponseID(ShoppingResponseIDType shoppingResponseID) {
        this.shoppingResponseID = shoppingResponseID;
    }
}
