
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AIRLINE FLIGHT COUPON definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponSoldAirlineType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CoreDateGrpType" name="DepartureDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:CoreDateGrpType" name="ArrivalDateTime" minOccurs="0"/>
 *     &lt;xs:element name="Stops" minOccurs="0">
 *       &lt;!-- Reference to inner class Stops -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="InfoSource" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TourOperatorFlightID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Departure" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Arrival" minOccurs="0"/>
 *     &lt;xs:element name="OperatingCarrier" minOccurs="0">
 *       &lt;!-- Reference to inner class OperatingCarrier -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:MarketingCarrierFlightType" name="MarketingCarrier" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Equipment" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SeatNumber" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddlBaggageInfoType" name="TicketedBaggageAllowance" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjectKeyMetaAttrGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MetadataToken"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponSoldAirlineType implements Serializable
{
    private CoreDateGrpType departureDateTime;
    private CoreDateGrpType arrivalDateTime;
    private Stops stops;
    private String infoSource;
    private String tourOperatorFlightID;
    private FlightDepartureType departure;
    private FlightArrivalType arrival;
    private OperatingCarrier operatingCarrier;
    private MarketingCarrierFlightType marketingCarrier;
    private List<AircraftSummaryType> equipmentList = new ArrayList<AircraftSummaryType>();
    private String status;
    private String seatNumber;
    private AddlBaggageInfoType ticketedBaggageAllowance;
    private ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup;
    private String metadataToken;

    /** 
     * Get the 'DepartureDateTime' element value. Scheduled, intended or actual departure date/ time.
     * 
     * @return value
     */
    public CoreDateGrpType getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value. Scheduled, intended or actual departure date/ time.
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(CoreDateGrpType departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'ArrivalDateTime' element value. Arrival date/ time.
     * 
     * @return value
     */
    public CoreDateGrpType getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' element value. Arrival date/ time.
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(CoreDateGrpType arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'Stops' element value.
     * 
     * @return value
     */
    public Stops getStops() {
        return stops;
    }

    /** 
     * Set the 'Stops' element value.
     * 
     * @param stops
     */
    public void setStops(Stops stops) {
        this.stops = stops;
    }

    /** 
     * Get the 'InfoSource' element value. Information Source. Example: BA
     * 
     * @return value
     */
    public String getInfoSource() {
        return infoSource;
    }

    /** 
     * Set the 'InfoSource' element value. Information Source. Example: BA
     * 
     * @param infoSource
     */
    public void setInfoSource(String infoSource) {
        this.infoSource = infoSource;
    }

    /** 
     * Get the 'TourOperatorFlightID' element value. Tour Operator Flight ID.

    Note: This is an ID for the flight as represented by a Tour Operator. This flight is not necessarily in the inventory of an airline as it is a code created by tour operators.  
     * 
     * @return value
     */
    public String getTourOperatorFlightID() {
        return tourOperatorFlightID;
    }

    /** 
     * Set the 'TourOperatorFlightID' element value. Tour Operator Flight ID.

    Note: This is an ID for the flight as represented by a Tour Operator. This flight is not necessarily in the inventory of an airline as it is a code created by tour operators.  
     * 
     * @param tourOperatorFlightID
     */
    public void setTourOperatorFlightID(String tourOperatorFlightID) {
        this.tourOperatorFlightID = tourOperatorFlightID;
    }

    /** 
     * Get the 'Departure' element value.
     * 
     * @return value
     */
    public FlightDepartureType getDeparture() {
        return departure;
    }

    /** 
     * Set the 'Departure' element value.
     * 
     * @param departure
     */
    public void setDeparture(FlightDepartureType departure) {
        this.departure = departure;
    }

    /** 
     * Get the 'Arrival' element value.
     * 
     * @return value
     */
    public FlightArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value.
     * 
     * @param arrival
     */
    public void setArrival(FlightArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'OperatingCarrier' element value.
     * 
     * @return value
     */
    public OperatingCarrier getOperatingCarrier() {
        return operatingCarrier;
    }

    /** 
     * Set the 'OperatingCarrier' element value.
     * 
     * @param operatingCarrier
     */
    public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
        this.operatingCarrier = operatingCarrier;
    }

    /** 
     * Get the 'MarketingCarrier' element value. Marketing Carrier information.

    Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
     * 
     * @return value
     */
    public MarketingCarrierFlightType getMarketingCarrier() {
        return marketingCarrier;
    }

    /** 
     * Set the 'MarketingCarrier' element value. Marketing Carrier information.

    Notes: This is the carrier that sells with its own code as part of a code share agreement on a flight that is actually operated by another carrier.
     * 
     * @param marketingCarrier
     */
    public void setMarketingCarrier(MarketingCarrierFlightType marketingCarrier) {
        this.marketingCarrier = marketingCarrier;
    }

    /** 
     * Get the list of 'Equipment' element items. Aircraft Equipment.

    Note: Two instances of aircraft equipment may be specified if there is a change of gauge.
     * 
     * @return list
     */
    public List<AircraftSummaryType> getEquipmentList() {
        return equipmentList;
    }

    /** 
     * Set the list of 'Equipment' element items. Aircraft Equipment.

    Note: Two instances of aircraft equipment may be specified if there is a change of gauge.
     * 
     * @param list
     */
    public void setEquipmentList(List<AircraftSummaryType> list) {
        equipmentList = list;
    }

    /** 
     * Get the 'Status' element value. Reservation Status Code.

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Reservation Status Code.

    Encoding Scheme: IATA Padis Codeset - List for data element 4405 (Status, coded)
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'SeatNumber' element value. Seat Number. Example: 112B

    Note: This is a seat assignment reserved for a confirmed flight at the time of ticket issuance.
     * 
     * @return value
     */
    public String getSeatNumber() {
        return seatNumber;
    }

    /** 
     * Set the 'SeatNumber' element value. Seat Number. Example: 112B

    Note: This is a seat assignment reserved for a confirmed flight at the time of ticket issuance.
     * 
     * @param seatNumber
     */
    public void setSeatNumber(String seatNumber) {
        this.seatNumber = seatNumber;
    }

    /** 
     * Get the 'TicketedBaggageAllowance' element value. Baggage related disclosures to passengers as required by several governments.
     * 
     * @return value
     */
    public AddlBaggageInfoType getTicketedBaggageAllowance() {
        return ticketedBaggageAllowance;
    }

    /** 
     * Set the 'TicketedBaggageAllowance' element value. Baggage related disclosures to passengers as required by several governments.
     * 
     * @param ticketedBaggageAllowance
     */
    public void setTicketedBaggageAllowance(
            AddlBaggageInfoType ticketedBaggageAllowance) {
        this.ticketedBaggageAllowance = ticketedBaggageAllowance;
    }

    /** 
     * Get the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectKeyMetaAttrGroup getObjectKeyMetaAttrGroup() {
        return objectKeyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectKeyMetaAttrGroup' attributeGroup value.
     * 
     * @param objectKeyMetaAttrGroup
     */
    public void setObjectKeyMetaAttrGroup(
            ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup) {
        this.objectKeyMetaAttrGroup = objectKeyMetaAttrGroup;
    }

    /** 
     * Get the 'MetadataToken' attribute value. Unique Metadata Collection Token.

    Example: jZhJu7SORZeO MNpifElIkA

    Note: This token pertains to all specified metadata information, e.g. the metadata collection.
     * 
     * @return value
     */
    public String getMetadataToken() {
        return metadataToken;
    }

    /** 
     * Set the 'MetadataToken' attribute value. Unique Metadata Collection Token.

    Example: jZhJu7SORZeO MNpifElIkA

    Note: This token pertains to all specified metadata information, e.g. the metadata collection.
     * 
     * @param metadataToken
     */
    public void setMetadataToken(String metadataToken) {
        this.metadataToken = metadataToken;
    }
    /** 
     * Flight Stop Quantity and Location(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Stops" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="StopQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="ns:StopLocations" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Stops implements Serializable
    {
        private String stopQuantity;
        private StopLocationType stopLocations;

        /** 
         * Get the 'StopQuantity' element value. Stop Quantity. Example: 1
         * 
         * @return value
         */
        public String getStopQuantity() {
            return stopQuantity;
        }

        /** 
         * Set the 'StopQuantity' element value. Stop Quantity. Example: 1
         * 
         * @param stopQuantity
         */
        public void setStopQuantity(String stopQuantity) {
            this.stopQuantity = stopQuantity;
        }

        /** 
         * Get the 'StopLocations' element value.
         * 
         * @return value
         */
        public StopLocationType getStopLocations() {
            return stopLocations;
        }

        /** 
         * Set the 'StopLocations' element value.
         * 
         * @param stopLocations
         */
        public void setStopLocations(StopLocationType stopLocations) {
            this.stopLocations = stopLocations;
        }
    }
    /** 
     * Operating Carrier Information.

    Operating Carrier is the carrier that operates a flight with a reference to its own prime flight number.

    Note: Operating Carrier may be different from a Marketing Carrier(s), if the flight is actually marketed by another carrier(s) within a codeshare agreement. 

    Operating Carrier may not be the AOC holder, in which case, and wherever required, this will need to be disclosed to the customer.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:OperatingCarrierFlightType">
     *         &lt;xs:sequence>
     *           &lt;xs:element ref="ns:Disclosures" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OperatingCarrier extends OperatingCarrierFlightType
        implements Serializable
    {
        private DisclosureType disclosures;

        /** 
         * Get the 'Disclosures' element value.
         * 
         * @return value
         */
        public DisclosureType getDisclosures() {
            return disclosures;
        }

        /** 
         * Set the 'Disclosures' element value.
         * 
         * @param disclosures
         */
        public void setDisclosures(DisclosureType disclosures) {
            this.disclosures = disclosures;
        }
    }
}
