
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * COUPON TICKET DOCUMENT definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CouponTicketDocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketDocNbr"/>
 *     &lt;xs:element type="xs:string" name="Type"/>
 *     &lt;xs:element type="xs:string" name="InConnectionDocNbr" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberofBooklets"/>
 *     &lt;xs:element type="xs:date" name="DateOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TimeOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TicketingLocation" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RoutingDomIntCode" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirlineID_Type" name="FeeOwner" minOccurs="0"/>
 *     &lt;xs:element type="ns:AddlBaggageInfoType" name="AddlBaggageInfo" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Remark" minOccurs="0"/>
 *     &lt;xs:element type="ns:CouponInfoType" name="CouponInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PenaltyReferences" minOccurs="0"/>
 *     &lt;xs:element name="ReportingType">
 *       &lt;xs:simpleType>
 *         &lt;!-- Reference to inner class ReportingType -->
 *       &lt;/xs:simpleType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CouponTicketDocType implements Serializable
{
    private String ticketDocNbr;
    private String type;
    private String inConnectionDocNbr;
    private BigInteger numberofBooklets;
    private Date dateOfIssue;
    private String timeOfIssue;
    private String ticketingLocation;
    private String routingDomIntCode;
    private AirlineIDType feeOwner;
    private AddlBaggageInfoType addlBaggageInfo;
    private String remark;
    private List<CouponInfoType> couponInfoList = new ArrayList<CouponInfoType>();
    private String penaltyReferences;
    private ReportingType reportingType;

    /** 
     * Get the 'TicketDocNbr' element value. Coupon Document Number.

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketDocNbr() {
        return ticketDocNbr;
    }

    /** 
     * Set the 'TicketDocNbr' element value. Coupon Document Number.

    Note: This is the document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketDocNbr
     */
    public void setTicketDocNbr(String ticketDocNbr) {
        this.ticketDocNbr = ticketDocNbr;
    }

    /** 
     * Get the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Coupon Type. Example: Y (EMD-S Standalone)

    Encoding Scheme: IATA Padis Codeset - List for data element 1001 (Document/ Message Name, coded)
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'InConnectionDocNbr' element value. Connected Document Number.

    Note: This is a ticket/ document to which this document is connected.
     * 
     * @return value
     */
    public String getInConnectionDocNbr() {
        return inConnectionDocNbr;
    }

    /** 
     * Set the 'InConnectionDocNbr' element value. Connected Document Number.

    Note: This is a ticket/ document to which this document is connected.
     * 
     * @param inConnectionDocNbr
     */
    public void setInConnectionDocNbr(String inConnectionDocNbr) {
        this.inConnectionDocNbr = inConnectionDocNbr;
    }

    /** 
     * Get the 'NumberofBooklets' element value. The number of booklets issued.
     * 
     * @return value
     */
    public BigInteger getNumberofBooklets() {
        return numberofBooklets;
    }

    /** 
     * Set the 'NumberofBooklets' element value. The number of booklets issued.
     * 
     * @param numberofBooklets
     */
    public void setNumberofBooklets(BigInteger numberofBooklets) {
        this.numberofBooklets = numberofBooklets;
    }

    /** 
     * Get the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
     * 
     * @return value
     */
    public Date getDateOfIssue() {
        return dateOfIssue;
    }

    /** 
     * Set the 'DateOfIssue' element value. Date of Issue. Example: 2017-01-13
     * 
     * @param dateOfIssue
     */
    public void setDateOfIssue(Date dateOfIssue) {
        this.dateOfIssue = dateOfIssue;
    }

    /** 
     * Get the 'TimeOfIssue' element value. Time of Issue. Example: 14:32
     * 
     * @return value
     */
    public String getTimeOfIssue() {
        return timeOfIssue;
    }

    /** 
     * Set the 'TimeOfIssue' element value. Time of Issue. Example: 14:32
     * 
     * @param timeOfIssue
     */
    public void setTimeOfIssue(String timeOfIssue) {
        this.timeOfIssue = timeOfIssue;
    }

    /** 
     * Get the 'TicketingLocation' element value. Airport or City Code. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @return value
     */
    public String getTicketingLocation() {
        return ticketingLocation;
    }

    /** 
     * Set the 'TicketingLocation' element value. Airport or City Code. Example: JFK

    Encoding Scheme: IATA/ A4A (three character) Airport or City Code
     * 
     * @param ticketingLocation
     */
    public void setTicketingLocation(String ticketingLocation) {
        this.ticketingLocation = ticketingLocation;
    }

    /** 
     * Get the 'RoutingDomIntCode' element value. Ticket Routing Code. Example: D

    Note: This is for EMD-A and EMD-S tickets with routing.
    - Use D - if all board and off points are within the same country
    - Use I - if all board and off points are  not within the same country
    - For an EMD-S with no routing, do not use.
     * 
     * @return value
     */
    public String getRoutingDomIntCode() {
        return routingDomIntCode;
    }

    /** 
     * Set the 'RoutingDomIntCode' element value. Ticket Routing Code. Example: D

    Note: This is for EMD-A and EMD-S tickets with routing.
    - Use D - if all board and off points are within the same country
    - Use I - if all board and off points are  not within the same country
    - For an EMD-S with no routing, do not use.
     * 
     * @param routingDomIntCode
     */
    public void setRoutingDomIntCode(String routingDomIntCode) {
        this.routingDomIntCode = routingDomIntCode;
    }

    /** 
     * Get the 'FeeOwner' element value. Airline Designator. Example: BA

    Note: This is the airline designator representing the carrier whose fee was used on the EMD coupons.
     * 
     * @return value
     */
    public AirlineIDType getFeeOwner() {
        return feeOwner;
    }

    /** 
     * Set the 'FeeOwner' element value. Airline Designator. Example: BA

    Note: This is the airline designator representing the carrier whose fee was used on the EMD coupons.
     * 
     * @param feeOwner
     */
    public void setFeeOwner(AirlineIDType feeOwner) {
        this.feeOwner = feeOwner;
    }

    /** 
     * Get the 'AddlBaggageInfo' element value. Carry-on and checked baggage allowances.
     * 
     * @return value
     */
    public AddlBaggageInfoType getAddlBaggageInfo() {
        return addlBaggageInfo;
    }

    /** 
     * Set the 'AddlBaggageInfo' element value. Carry-on and checked baggage allowances.
     * 
     * @param addlBaggageInfo
     */
    public void setAddlBaggageInfo(AddlBaggageInfoType addlBaggageInfo) {
        this.addlBaggageInfo = addlBaggageInfo;
    }

    /** 
     * Get the 'Remark' element value. Free text to provide further information related to the document and/or the coupon.
     * 
     * @return value
     */
    public String getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. Free text to provide further information related to the document and/or the coupon.
     * 
     * @param remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /** 
     * Get the list of 'CouponInfo' element items. Coupon information.
     * 
     * @return list
     */
    public List<CouponInfoType> getCouponInfoList() {
        return couponInfoList;
    }

    /** 
     * Set the list of 'CouponInfo' element items. Coupon information.
     * 
     * @param list
     */
    public void setCouponInfoList(List<CouponInfoType> list) {
        couponInfoList = list;
    }

    /** 
     * Get the 'PenaltyReferences' element value. Association to Penalty element in DataList. Example: PN1 PN2
     * 
     * @return value
     */
    public String getPenaltyReferences() {
        return penaltyReferences;
    }

    /** 
     * Set the 'PenaltyReferences' element value. Association to Penalty element in DataList. Example: PN1 PN2
     * 
     * @param penaltyReferences
     */
    public void setPenaltyReferences(String penaltyReferences) {
        this.penaltyReferences = penaltyReferences;
    }

    /** 
     * Get the 'ReportingType' element value. For billing and settlement purposes, each time a travel agent requests an airline to perform an action on a document (Issuance, Refund, Exchange), he needs to know how to reconciliate this action: via BSP, via ARC, directly done by the ORA, etc.
     * 
     * @return value
     */
    public ReportingType getReportingType() {
        return reportingType;
    }

    /** 
     * Set the 'ReportingType' element value. For billing and settlement purposes, each time a travel agent requests an airline to perform an action on a document (Issuance, Refund, Exchange), he needs to know how to reconciliate this action: via BSP, via ARC, directly done by the ORA, etc.
     * 
     * @param reportingType
     */
    public void setReportingType(ReportingType reportingType) {
        this.reportingType = reportingType;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="BSP"/>
     *     &lt;xs:enumeration value="ARC"/>
     *     &lt;xs:enumeration value="Airline"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ReportingType implements Serializable {
        BSP("BSP"), ARC("ARC"), AIRLINE("Airline");
        private final String value;

        private ReportingType(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ReportingType convert(String value) {
            for (ReportingType inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
