
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Currency code. Example: USD

 Encoding Scheme: ISO 4217 (three alpha character) Currency Code
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrCode">
 *   &lt;xs:complexType>
 *     &lt;xs:simpleContent>
 *       &lt;xs:extension base="xs:string">
 *         &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="metadata"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="application"/>
 *         &lt;xs:attribute type="xs:int" use="optional" name="NumberOfDecimals"/>
 *       &lt;/xs:extension>
 *     &lt;/xs:simpleContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CurrCode implements Serializable
{
    private String string;
    private String id;
    private String metadata;
    private String refs;
    private String application;
    private Integer numberOfDecimals;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. A globally unique identifier for this object instance. 
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'metadata' attribute value. Association(s) between this object and any metadata instance(s).
     * 
     * @return value
     */
    public String getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'metadata' attribute value. Association(s) between this object and any metadata instance(s).
     * 
     * @param metadata
     */
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'application' attribute value. Currency code Application.
    Examples: Actual, Display, Requested, Conversion, Other
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'application' attribute value. Currency code Application.
    Examples: Actual, Display, Requested, Conversion, Other
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
     * 
     * @return value
     */
    public Integer getNumberOfDecimals() {
        return numberOfDecimals;
    }

    /** 
     * Set the 'NumberOfDecimals' attribute value. Decimal position in fare amount.  Example: 2
     * 
     * @param numberOfDecimals
     */
    public void setNumberOfDecimals(Integer numberOfDecimals) {
        this.numberOfDecimals = numberOfDecimals;
    }
}
