
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Currency Code Application list constraint.

 Examples: Actual, Display, Requested, Conversion, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Actual"/>
 *     &lt;xs:enumeration value="Conversion"/>
 *     &lt;xs:enumeration value="Display"/>
 *     &lt;xs:enumeration value="Requested"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CurrencyListType implements Serializable {
    ACTUAL("Actual"), CONVERSION("Conversion"), DISPLAY("Display"), REQUESTED(
            "Requested"), OTHER("Other");
    private final String value;

    private CurrencyListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CurrencyListType convert(String value) {
        for (CurrencyListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
