
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * A data type for CURRENCY Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *         &lt;xs:element type="xs:integer" name="Decimals" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrencyMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String application;
    private BigInteger decimals;
    private String name;

    /** 
     * Get the 'Application' element value. Currency application. Example: Actual Pricing, Display Currency, Requested Pricing
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Currency application. Example: Actual Pricing, Display Currency, Requested Pricing
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Decimals' element value. Number of decimal places. Example: 2.  Note this is the number of decimal places normally used when displaying amounts in this currency
     * 
     * @return value
     */
    public BigInteger getDecimals() {
        return decimals;
    }

    /** 
     * Set the 'Decimals' element value. Number of decimal places. Example: 2.  Note this is the number of decimal places normally used when displaying amounts in this currency
     * 
     * @param decimals
     */
    public void setDecimals(BigInteger decimals) {
        this.decimals = decimals;
    }

    /** 
     * Get the 'Name' element value. Currency name.  Example: US Dollars
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Currency name.  Example: US Dollars
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
