
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Customer Input Response Message Processing.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustInputResProcessType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociatedObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Notices" minOccurs="0"/>
 *         &lt;xs:element ref="ns:MarketingMessages" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="AlertInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="MarketingInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="WarningInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="NoticeInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustInputResProcessType extends AssociatedObjectBaseType implements
    Serializable
{
    private Notices notices;
    private MarketingMessages marketingMessages;
    private Policies policies;
    private Boolean alertInd;
    private Boolean marketingInd;
    private Boolean warningInd;
    private Boolean noticeInd;

    /** 
     * Get the 'Notices' element value.
     * 
     * @return value
     */
    public Notices getNotices() {
        return notices;
    }

    /** 
     * Set the 'Notices' element value.
     * 
     * @param notices
     */
    public void setNotices(Notices notices) {
        this.notices = notices;
    }

    /** 
     * Get the 'MarketingMessages' element value.
     * 
     * @return value
     */
    public MarketingMessages getMarketingMessages() {
        return marketingMessages;
    }

    /** 
     * Set the 'MarketingMessages' element value.
     * 
     * @param marketingMessages
     */
    public void setMarketingMessages(MarketingMessages marketingMessages) {
        this.marketingMessages = marketingMessages;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'AlertInd' attribute value. When true, processing alerts have been generated and the Alerts node should be parsed.
     * 
     * @return value
     */
    public Boolean getAlertInd() {
        return alertInd;
    }

    /** 
     * Set the 'AlertInd' attribute value. When true, processing alerts have been generated and the Alerts node should be parsed.
     * 
     * @param alertInd
     */
    public void setAlertInd(Boolean alertInd) {
        this.alertInd = alertInd;
    }

    /** 
     * Get the 'MarketingInd' attribute value. When true, supplemental marketing information has been generated and the Notifications/ MarketingMessage node should be parsed.
     * 
     * @return value
     */
    public Boolean getMarketingInd() {
        return marketingInd;
    }

    /** 
     * Set the 'MarketingInd' attribute value. When true, supplemental marketing information has been generated and the Notifications/ MarketingMessage node should be parsed.
     * 
     * @param marketingInd
     */
    public void setMarketingInd(Boolean marketingInd) {
        this.marketingInd = marketingInd;
    }

    /** 
     * Get the 'WarningInd' attribute value. When true, business warnings have been generated and the Notification/Warning node should be parsed.
     * 
     * @return value
     */
    public Boolean getWarningInd() {
        return warningInd;
    }

    /** 
     * Set the 'WarningInd' attribute value. When true, business warnings have been generated and the Notification/Warning node should be parsed.
     * 
     * @param warningInd
     */
    public void setWarningInd(Boolean warningInd) {
        this.warningInd = warningInd;
    }

    /** 
     * Get the 'NoticeInd' attribute value. When true, notices have been generated and the Notifications/Notice node should be parsed.
     * 
     * @return value
     */
    public Boolean getNoticeInd() {
        return noticeInd;
    }

    /** 
     * Set the 'NoticeInd' attribute value. When true, notices have been generated and the Notifications/Notice node should be parsed.
     * 
     * @param noticeInd
     */
    public void setNoticeInd(Boolean noticeInd) {
        this.noticeInd = noticeInd;
    }
}
