
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * The CustomerInput transaction set supports other EDIST transactions by providing discrete-but related-functional capabilities for customer authentication and 3D Secure Payment Authentication. Supported functionality includes:

 PIN Phrasing Scheme Membership: Predefined structures and keyword-value pairs are provided for 1.5FA (Factor Authentication) Traveler authentication.

 3-D Secure Payment Protocol: 3DS is designed to reduce fraud and chargebacks during e-commerce Internet transactions. Cardholders are asked to identify themselves at the point of sale before the purchase can be completed. This usually means entering a PIN or other password after entering their card details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInputRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element ref="ns:CustomerInputParameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *             &lt;xs:element type="ns:PIN_AuthTravelerType" name="PassengerAuthentication" minOccurs="0"/>
 *             &lt;xs:element name="SecurePayments" minOccurs="0">
 *               &lt;!-- Reference to inner class SecurePayments -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CustomerInputRQ implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private CusInputReqParamsType customerInputParameters;
    private PointOfSaleType queryPointOfSale;
    private PINAuthTravelerType queryPassengerAuthentication;
    private SecurePayments securePayments;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'CustomerInputParameters' element value.
     * 
     * @return value
     */
    public CusInputReqParamsType getCustomerInputParameters() {
        return customerInputParameters;
    }

    /** 
     * Set the 'CustomerInputParameters' element value.
     * 
     * @param customerInputParameters
     */
    public void setCustomerInputParameters(
            CusInputReqParamsType customerInputParameters) {
        this.customerInputParameters = customerInputParameters;
    }

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getQueryPointOfSale() {
        return queryPointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param queryPointOfSale
     */
    public void setQueryPointOfSale(PointOfSaleType queryPointOfSale) {
        this.queryPointOfSale = queryPointOfSale;
    }

    /** 
     * Get the 'PassengerAuthentication' element value. Passenger Pin Phrase Authentication.
     * 
     * @return value
     */
    public PINAuthTravelerType getQueryPassengerAuthentication() {
        return queryPassengerAuthentication;
    }

    /** 
     * Set the 'PassengerAuthentication' element value. Passenger Pin Phrase Authentication.
     * 
     * @param queryPassengerAuthentication
     */
    public void setQueryPassengerAuthentication(
            PINAuthTravelerType queryPassengerAuthentication) {
        this.queryPassengerAuthentication = queryPassengerAuthentication;
    }

    /** 
     * Get the 'SecurePayments' element value. Customer Input query parameters.
     * 
     * @return value
     */
    public SecurePayments getSecurePayments() {
        return securePayments;
    }

    /** 
     * Set the 'SecurePayments' element value. Customer Input query parameters.
     * 
     * @param securePayments
     */
    public void setSecurePayments(SecurePayments securePayments) {
        this.securePayments = securePayments;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * 3D Secure Payment Program Enrollment, Verification and Authentication information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SecurePayment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SecurePayment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SecurePayments implements Serializable
    {
        private List<SecurePayment> securePaymentList = new ArrayList<SecurePayment>();

        /** 
         * Get the list of 'SecurePayment' element items.
         * 
         * @return list
         */
        public List<SecurePayment> getSecurePaymentList() {
            return securePaymentList;
        }

        /** 
         * Set the list of 'SecurePayment' element items.
         * 
         * @param list
         */
        public void setSecurePaymentList(List<SecurePayment> list) {
            securePaymentList = list;
        }
        /** 
         * 3D Secure Payment detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SecurePaymentAlertType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="ns:CurrencyAmountOptType" name="Amount" minOccurs="0"/>
         *           &lt;xs:element type="ns:PaymentCardType" name="PaymentCard" minOccurs="0"/>
         *           &lt;xs:element name="Approval" minOccurs="0">
         *             &lt;!-- Reference to inner class Approval -->
         *           &lt;/xs:element>
         *           &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
         *           &lt;xs:element ref="ns:Associations" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SecurePayment extends SecurePaymentAlertType
            implements Serializable
        {
            private CurrencyAmountOptType amount;
            private PaymentCardType paymentCard;
            private Approval approval;
            private String qualifier;
            private Associations associations;

            /** 
             * Get the 'Amount' element value. Payment Amount. Example: 300 USD
             * 
             * @return value
             */
            public CurrencyAmountOptType getAmount() {
                return amount;
            }

            /** 
             * Set the 'Amount' element value. Payment Amount. Example: 300 USD
             * 
             * @param amount
             */
            public void setAmount(CurrencyAmountOptType amount) {
                this.amount = amount;
            }

            /** 
             * Get the 'PaymentCard' element value. Payment Card information.
             * 
             * @return value
             */
            public PaymentCardType getPaymentCard() {
                return paymentCard;
            }

            /** 
             * Set the 'PaymentCard' element value. Payment Card information.
             * 
             * @param paymentCard
             */
            public void setPaymentCard(PaymentCardType paymentCard) {
                this.paymentCard = paymentCard;
            }

            /** 
             * Get the 'Approval' element value.
             * 
             * @return value
             */
            public Approval getApproval() {
                return approval;
            }

            /** 
             * Set the 'Approval' element value.
             * 
             * @param approval
             */
            public void setApproval(Approval approval) {
                this.approval = approval;
            }

            /** 
             * Get the 'Qualifier' element value. Used to specify if this is the old, new, or orginal form of payment.

            Encoding Scheme: IATA  PADIS code list 9988
             * 
             * @return value
             */
            public String getQualifier() {
                return qualifier;
            }

            /** 
             * Set the 'Qualifier' element value. Used to specify if this is the old, new, or orginal form of payment.

            Encoding Scheme: IATA  PADIS code list 9988
             * 
             * @param qualifier
             */
            public void setQualifier(String qualifier) {
                this.qualifier = qualifier;
            }

            /** 
             * Get the 'Associations' element value.
             * 
             * @return value
             */
            public Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value.
             * 
             * @param associations
             */
            public void setAssociations(Associations associations) {
                this.associations = associations;
            }
            /** 
             * Payment Approval/ Authorization information.

            Note: This includes pre-authorized transaction and authorization status.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Approval" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="ApprovalType" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
             *       &lt;xs:element type="xs:dateTime" name="TrxTimestamp" minOccurs="0"/>
             *       &lt;xs:element type="xs:string" name="TrxReference" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="PreAuthorizedInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Approval implements Serializable
            {
                private String approvalType;
                private String code;
                private Date trxTimestamp;
                private String trxReference;
                private Boolean preAuthorizedInd;

                /** 
                 * Get the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

                Note: This is used to specify how the approval code for a credit card sale was obtained.

                Encoding Scheme: IATA PADIS Code List for data element 9890.
                 * 
                 * @return value
                 */
                public String getApprovalType() {
                    return approvalType;
                }

                /** 
                 * Set the 'ApprovalType' element value. Approval Code Method. Example: M (Manual)

                Note: This is used to specify how the approval code for a credit card sale was obtained.

                Encoding Scheme: IATA PADIS Code List for data element 9890.
                 * 
                 * @param approvalType
                 */
                public void setApprovalType(String approvalType) {
                    this.approvalType = approvalType;
                }

                /** 
                 * Get the 'Code' element value. The approval code returned as part of an authorization process.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' element value. The approval code returned as part of an authorization process.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'TrxTimestamp' element value. Transaction Timestamp. Example: 2015-01-13T13:59:38Z
                 * 
                 * @return value
                 */
                public Date getTrxTimestamp() {
                    return trxTimestamp;
                }

                /** 
                 * Set the 'TrxTimestamp' element value. Transaction Timestamp. Example: 2015-01-13T13:59:38Z
                 * 
                 * @param trxTimestamp
                 */
                public void setTrxTimestamp(Date trxTimestamp) {
                    this.trxTimestamp = trxTimestamp;
                }

                /** 
                 * Get the 'TrxReference' element value. The approval code returned as part of an authorization process.
                 * 
                 * @return value
                 */
                public String getTrxReference() {
                    return trxReference;
                }

                /** 
                 * Set the 'TrxReference' element value. The approval code returned as part of an authorization process.
                 * 
                 * @param trxReference
                 */
                public void setTrxReference(String trxReference) {
                    this.trxReference = trxReference;
                }

                /** 
                 * Get the 'PreAuthorizedInd' attribute value. When true, this transaction has been pre-authorized.
                 * 
                 * @return value
                 */
                public Boolean getPreAuthorizedInd() {
                    return preAuthorizedInd;
                }

                /** 
                 * Set the 'PreAuthorizedInd' attribute value. When true, this transaction has been pre-authorized.
                 * 
                 * @param preAuthorizedInd
                 */
                public void setPreAuthorizedInd(Boolean preAuthorizedInd) {
                    this.preAuthorizedInd = preAuthorizedInd;
                }
            }
        }
    }
}
