
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The CustomerInput transaction set supports other EDIST transactions by providing discrete-but related-functional capabilities for customer authentication and 3D Secure Payment Authentication. Supported functionality includes:

 PIN Phrasing Scheme Membership: Predefined structures and keyword-value pairs are provided for 1.5FA (Factor Authentication) Traveler authentication.

 3-D Secure Payment Protocol: 3DS is designed to reduce fraud and chargebacks during e-commerce Internet transactions. Cardholders are asked to identify themselves at the point of sale before the purchase can be completed. This usually means entering a PIN or other password after entering their card details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerInputRS">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;xs:element type="ns:SuccessType" name="Success"/>
 *           &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *           &lt;xs:element name="Response">
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element ref="ns:CustomerInputProcessing" minOccurs="0"/>
 *                 &lt;xs:element type="ns:PIN_AuthTravelerType" name="PassengerAuthentication" minOccurs="0"/>
 *                 &lt;xs:element name="SecurePayments" minOccurs="0">
 *                   &lt;!-- Reference to inner class SecurePayments -->
 *                 &lt;/xs:element>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:element ref="ns:Errors"/>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class CustomerInputRS implements Serializable
{
    private MsgDocumentType document;
    private int choiceSelect = -1;
    private static final int SUCCESS_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private SuccessType success;
    private WarningsType warnings;
    private CustInputResProcessType responseCustomerInputProcessing;
    private PINAuthTravelerType responsePassengerAuthentication;
    private SecurePayments securePayments;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Success is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSuccess() {
        return choiceSelect == SUCCESS_CHOICE;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'CustomerInputProcessing' element value.
     * 
     * @return value
     */
    public CustInputResProcessType getResponseCustomerInputProcessing() {
        return responseCustomerInputProcessing;
    }

    /** 
     * Set the 'CustomerInputProcessing' element value.
     * 
     * @param responseCustomerInputProcessing
     */
    public void setResponseCustomerInputProcessing(
            CustInputResProcessType responseCustomerInputProcessing) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responseCustomerInputProcessing = responseCustomerInputProcessing;
    }

    /** 
     * Get the 'PassengerAuthentication' element value. Passenger Pin Phrase Authentication.
     * 
     * @return value
     */
    public PINAuthTravelerType getResponsePassengerAuthentication() {
        return responsePassengerAuthentication;
    }

    /** 
     * Set the 'PassengerAuthentication' element value. Passenger Pin Phrase Authentication.
     * 
     * @param responsePassengerAuthentication
     */
    public void setResponsePassengerAuthentication(
            PINAuthTravelerType responsePassengerAuthentication) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.responsePassengerAuthentication = responsePassengerAuthentication;
    }

    /** 
     * Get the 'SecurePayments' element value. Query Results.
     * 
     * @return value
     */
    public SecurePayments getSecurePayments() {
        return securePayments;
    }

    /** 
     * Set the 'SecurePayments' element value. Query Results.
     * 
     * @param securePayments
     */
    public void setSecurePayments(SecurePayments securePayments) {
        setChoiceSelect(SUCCESS_CHOICE);
        this.securePayments = securePayments;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * 3D Secure Payment Program Enrollment, Verification and Authentication information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="SecurePayment" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class SecurePayment -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SecurePayments implements Serializable
    {
        private List<SecurePayment> securePaymentList = new ArrayList<SecurePayment>();

        /** 
         * Get the list of 'SecurePayment' element items.
         * 
         * @return list
         */
        public List<SecurePayment> getSecurePaymentList() {
            return securePaymentList;
        }

        /** 
         * Set the list of 'SecurePayment' element items.
         * 
         * @param list
         */
        public void setSecurePaymentList(List<SecurePayment> list) {
            securePaymentList = list;
        }
        /** 
         * 3D Secure Payment detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayment" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:SecurePaymentAlertType">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="Status" minOccurs="0">
         *             &lt;!-- Reference to inner class Status -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SecurePayment extends SecurePaymentAlertType
            implements Serializable
        {
            private Status status;

            /** 
             * Get the 'Status' element value.
             * 
             * @return value
             */
            public Status getStatus() {
                return status;
            }

            /** 
             * Set the 'Status' element value.
             * 
             * @param status
             */
            public void setStatus(Status status) {
                this.status = status;
            }
            /** 
             * Traveler Authentication process status.
            Examples:
            Y- Customer authenticated
            N- Customer not authenticated
            A- An authentication attempt occurred but could not be completed
            U- Unable to perform authentication
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Status" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Status implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Authentication Status Context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Authentication Status Context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
}
