
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.sql.Date;

/** 
 * A data type for Effective/ Expiration Short Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatePeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="xs:date" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatePeriodRepType implements Serializable
{
    private Date effective;
    private Date expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) date.  Example: 2017-01-13

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param effective
     */
    public void setEffective(Date effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @return value
     */
    public Date getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) date.  Example: 2017-01-14

    Encoding Scheme: ISO 8601 Date Format (YYYY-MM-DD)
     * 
     * @param expiration
     */
    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }
}
