
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Effective/ Expiration Day of Week Date Period Representation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DayPeriodRepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DayRepType" name="Effective" minOccurs="0"/>
 *     &lt;xs:element type="ns:DayRepType" name="Expiration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DayPeriodRepType implements Serializable
{
    private DayRepType effective;
    private DayRepType expiration;

    /** 
     * Get the 'Effective' element value. Effective (start) day of the week number.  Example: 01
     * 
     * @return value
     */
    public DayRepType getEffective() {
        return effective;
    }

    /** 
     * Set the 'Effective' element value. Effective (start) day of the week number.  Example: 01
     * 
     * @param effective
     */
    public void setEffective(DayRepType effective) {
        this.effective = effective;
    }

    /** 
     * Get the 'Expiration' element value. Expiration (end) day of the week number.  Example: 04
     * 
     * @return value
     */
    public DayRepType getExpiration() {
        return expiration;
    }

    /** 
     * Set the 'Expiration' element value. Expiration (end) day of the week number.  Example: 04
     * 
     * @param expiration
     */
    public void setExpiration(DayRepType expiration) {
        this.expiration = expiration;
    }
}
