
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.Date;

/** 
 * Order/ Order Item: DEPOSIT Time Limit definition.

 Deposit Must be Paid By Time Limit value.
 Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

 Note: This is the time by which a deposit must be paid for an Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepositTimeLimitType">
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 *   &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DepositTimeLimitType implements Serializable
{
    private String refs;
    private Date timestamp;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @return value
     */
    public Date getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' attribute value. Timestamp. Example: 2017-01-13T13:59:38Z
     * 
     * @param timestamp
     */
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }
}
