
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * DIRECT BILLING Payment Form definition.

 Company name and location for sending invoice for remittances for travel services.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectBillType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DirectBillID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CompanyName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ContactName" minOccurs="0"/>
 *     &lt;xs:element name="Address" minOccurs="0">
 *       &lt;!-- Reference to inner class Address -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DirectBillType implements Serializable
{
    private String directBillID;
    private String companyName;
    private String contactName;
    private Address address;
    private String refs;

    /** 
     * Get the 'DirectBillID' element value. Direct billing Organizaqtion ID. Example: IBM
     * 
     * @return value
     */
    public String getDirectBillID() {
        return directBillID;
    }

    /** 
     * Set the 'DirectBillID' element value. Direct billing Organizaqtion ID. Example: IBM
     * 
     * @param directBillID
     */
    public void setDirectBillID(String directBillID) {
        this.directBillID = directBillID;
    }

    /** 
     * Get the 'CompanyName' element value. Remit to Company Name. Example: IBM

    Note: This is the company name to whom remittance should be directed.
     * 
     * @return value
     */
    public String getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. Remit to Company Name. Example: IBM

    Note: This is the company name to whom remittance should be directed.
     * 
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /** 
     * Get the 'ContactName' element value. Direct Billing Contact Name. Example: J THOMAS
     * 
     * @return value
     */
    public String getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. Direct Billing Contact Name. Example: J THOMAS
     * 
     * @param contactName
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'Address' element value.
     * 
     * @return value
     */
    public Address getAddress() {
        return address;
    }

    /** 
     * Set the 'Address' element value.
     * 
     * @param address
     */
    public void setAddress(Address address) {
        this.address = address;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Address where remittance should be directed.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Address" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:StructuredAddress"/>
     *       &lt;xs:element ref="ns:SimpleAddress"/>
     *       &lt;xs:element ref="ns:PaymentAddress"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Address implements Serializable
    {
        private StructuredAddress structuredAddress;
        private SimpleAddrType simpleAddress;
        private PaymentAddrType paymentAddress;

        /** 
         * Get the 'StructuredAddress' element value.
         * 
         * @return value
         */
        public StructuredAddress getStructuredAddress() {
            return structuredAddress;
        }

        /** 
         * Set the 'StructuredAddress' element value.
         * 
         * @param structuredAddress
         */
        public void setStructuredAddress(StructuredAddress structuredAddress) {
            this.structuredAddress = structuredAddress;
        }

        /** 
         * Get the 'SimpleAddress' element value.
         * 
         * @return value
         */
        public SimpleAddrType getSimpleAddress() {
            return simpleAddress;
        }

        /** 
         * Set the 'SimpleAddress' element value.
         * 
         * @param simpleAddress
         */
        public void setSimpleAddress(SimpleAddrType simpleAddress) {
            this.simpleAddress = simpleAddress;
        }

        /** 
         * Get the 'PaymentAddress' element value.
         * 
         * @return value
         */
        public PaymentAddrType getPaymentAddress() {
            return paymentAddress;
        }

        /** 
         * Set the 'PaymentAddress' element value.
         * 
         * @param paymentAddress
         */
        public void setPaymentAddress(PaymentAddrType paymentAddress) {
            this.paymentAddress = paymentAddress;
        }
    }
}
