
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * DISCOUNT core representation.

 This element is used for informational purposes only and the Total Price already reflects and includes this discount amount/percent.NDC Capability: Discount

 1. Discount amount value may be represented as a fixed amount or a percentage.
 2. Contextual discount application (e.g. category) may be specified.
 3. Metadata may be defined.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiscountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:DiscountAmount" minOccurs="0"/>
 *     &lt;xs:element ref="ns:DiscountPercent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DiscountType implements Serializable
{
    private DiscountAmount discountAmount;
    private DiscountPercent discountPercent;
    private String application;
    private String description;
    private String refs;

    /** 
     * Get the 'DiscountAmount' element value.
     * 
     * @return value
     */
    public DiscountAmount getDiscountAmount() {
        return discountAmount;
    }

    /** 
     * Set the 'DiscountAmount' element value.
     * 
     * @param discountAmount
     */
    public void setDiscountAmount(DiscountAmount discountAmount) {
        this.discountAmount = discountAmount;
    }

    /** 
     * Get the 'DiscountPercent' element value.
     * 
     * @return value
     */
    public DiscountPercent getDiscountPercent() {
        return discountPercent;
    }

    /** 
     * Set the 'DiscountPercent' element value.
     * 
     * @param discountPercent
     */
    public void setDiscountPercent(DiscountPercent discountPercent) {
        this.discountPercent = discountPercent;
    }

    /** 
     * Get the 'Application' element value. Discount Application.  Example: BAG
     * 
     * @return value
     */
    public String getApplication() {
        return application;
    }

    /** 
     * Set the 'Application' element value. Discount Application.  Example: BAG
     * 
     * @param application
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /** 
     * Get the 'Description' element value. Discount Description.
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Discount Description.
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
