
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * The email address which should be used for contact purposes.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmailAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Label" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EmailAddressValue" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EmailAddressType implements Serializable
{
    private String label;
    private String emailAddressValue;

    /** 
     * Get the 'Label' element value. Used to differentiate multiple email addresses of one contact. 
     * 
     * @return value
     */
    public String getLabel() {
        return label;
    }

    /** 
     * Set the 'Label' element value. Used to differentiate multiple email addresses of one contact. 
     * 
     * @param label
     */
    public void setLabel(String label) {
        this.label = label;
    }

    /** 
     * Get the 'EmailAddressValue' element value. The email address which should be used for contact purposes.
     * 
     * @return value
     */
    public String getEmailAddressValue() {
        return emailAddressValue;
    }

    /** 
     * Set the 'EmailAddressValue' element value. The email address which should be used for contact purposes.
     * 
     * @param emailAddressValue
     */
    public void setEmailAddressValue(String emailAddressValue) {
        this.emailAddressValue = emailAddressValue;
    }
}
