
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Email Application list constraints.
 Example: Account, Business, Personal, SMS, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmailListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Account"/>
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="Personal"/>
 *     &lt;xs:enumeration value="SMS"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EmailListType implements Serializable {
    ACCOUNT("Account"), BUSINESS("Business"), PERSONAL("Personal"), SMS("SMS"), OTHER(
            "Other");
    private final String value;

    private EmailListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EmailListType convert(String value) {
        for (EmailListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
