
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * 
 A data type for 3DS Program Enrollment Status contextual list. Examples: CardNotEnrolled, CardEnrolled, CardMayBeEnrolled, Unknown

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnrollStatusListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Disable"/>
 *     &lt;xs:enumeration value="Enable"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnrollStatusListType implements Serializable {
    DISABLE("Disable"), ENABLE("Enable");
    private final String value;

    private EnrollStatusListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnrollStatusListType convert(String value) {
        for (EnrollStatusListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
