
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * EXISTING ORDER Qualifier.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExistingOrderQualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:complexContent>
 *       &lt;xs:extension base="ns:OrderQualiferType">
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="ns:PassengerReferences"/>
 *           &lt;xs:element ref="ns:BookingReference" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *       &lt;/xs:extension>
 *     &lt;/xs:complexContent>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class ExistingOrderQualifier extends OrderQualiferType implements
    Serializable
{
    private PassengerReferences passengerReferences;
    private BookingReferenceType bookingReference;

    /** 
     * Get the 'PassengerReferences' element value.
     * 
     * @return value
     */
    public PassengerReferences getPassengerReferences() {
        return passengerReferences;
    }

    /** 
     * Set the 'PassengerReferences' element value.
     * 
     * @param passengerReferences
     */
    public void setPassengerReferences(PassengerReferences passengerReferences) {
        this.passengerReferences = passengerReferences;
    }

    /** 
     * Get the 'BookingReference' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @return value
     */
    public BookingReferenceType getBookingReference() {
        return bookingReference;
    }

    /** 
     * Set the 'BookingReference' element value. Existing Booking Reference (e.g. PNR Record Locator). Example: R1A3SK
     * 
     * @param bookingReference
     */
    public void setBookingReference(BookingReferenceType bookingReference) {
        this.bookingReference = bookingReference;
    }
}
