
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * Form of identification.  Typically used to identify that the passenger is who he says he is.

 This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FOID">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CreditCardVendorCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FOID_Number" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FOID_Type" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FOID implements Serializable
{
    private String creditCardVendorCode;
    private String FOIDNumber;
    private String FOIDType;

    /** 
     * Get the 'CreditCardVendorCode' element value. The CC vendor code in case FOID is a Credit Card.
     * 
     * @return value
     */
    public String getCreditCardVendorCode() {
        return creditCardVendorCode;
    }

    /** 
     * Set the 'CreditCardVendorCode' element value. The CC vendor code in case FOID is a Credit Card.
     * 
     * @param creditCardVendorCode
     */
    public void setCreditCardVendorCode(String creditCardVendorCode) {
        this.creditCardVendorCode = creditCardVendorCode;
    }

    /** 
     * Get the 'FOID_Number' element value. FOID ID value. Example: NY122345
     * 
     * @return value
     */
    public String getFOIDNumber() {
        return FOIDNumber;
    }

    /** 
     * Set the 'FOID_Number' element value. FOID ID value. Example: NY122345
     * 
     * @param FOIDNumber
     */
    public void setFOIDNumber(String FOIDNumber) {
        this.FOIDNumber = FOIDNumber;
    }

    /** 
     * Get the 'FOID_Type' element value. Form of identification type code used for booking/ticketing.  Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
     * 
     * @return value
     */
    public String getFOIDType() {
        return FOIDType;
    }

    /** 
     * Set the 'FOID_Type' element value. Form of identification type code used for booking/ticketing.  Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license)
     * 
     * @param FOIDType
     */
    public void setFOIDType(String FOIDType) {
        this.FOIDType = FOIDType;
    }
}
