
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;

/** 
 * A data type for Fare Application list constraint.

 Examples: Requested, Ticketed, Other
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasisListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Requested"/>
 *     &lt;xs:enumeration value="Ticketed"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FareBasisListType implements Serializable {
    REQUESTED("Requested"), TICKETED("Ticketed"), OTHER("Other");
    private final String value;

    private FareBasisListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FareBasisListType convert(String value) {
        for (FareBasisListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
