
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FareRules transaction set returns the filed details of a specific fare basis code (FBC).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRulesRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:PointOfSale" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element type="ns:MessageParamsBaseType" name="Parameters" minOccurs="0"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element ref="ns:Departure"/>
 *             &lt;xs:element ref="ns:Arrival"/>
 *             &lt;xs:element ref="ns:FareBasisCode"/>
 *             &lt;xs:element ref="ns:AirlineID"/>
 *             &lt;xs:element ref="ns:FareCode" minOccurs="0"/>
 *             &lt;xs:element ref="ns:FareInd" minOccurs="0"/>
 *             &lt;xs:element type="ns:FareQualifierType" name="SpecialFare" minOccurs="0"/>
 *             &lt;xs:element ref="ns:FareQualifierCodes" minOccurs="0"/>
 *             &lt;xs:element name="RuleCategories" minOccurs="0">
 *               &lt;!-- Reference to inner class RuleCategories -->
 *             &lt;/xs:element>
 *             &lt;xs:element ref="ns:FareTextInd" minOccurs="0"/>
 *             &lt;xs:element ref="ns:FareReferenceKey" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:FareRulesReqMetadataType" name="Metadata" minOccurs="0"/>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareRulesRQ implements Serializable
{
    private PointOfSaleType pointOfSale;
    private MsgDocumentType document;
    private MsgPartiesType party;
    private MessageParamsBaseType parameters;
    private FlightDepartureType queryDeparture;
    private FlightArrivalType queryArrival;
    private FareBasisCodeType queryFareBasisCode;
    private AirlineIDType queryAirlineID;
    private FareCode queryFareCode;
    private FareInd queryFareInd;
    private FareQualifierType querySpecialFare;
    private FareQualifierCodes queryFareQualifierCodes;
    private RuleCategories ruleCategories;
    private FareTextInd queryFareTextInd;
    private FareReferenceKey queryFareReferenceKey;
    private FareRulesReqMetadataType metadata;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'PointOfSale' element value.
     * 
     * @return value
     */
    public PointOfSaleType getPointOfSale() {
        return pointOfSale;
    }

    /** 
     * Set the 'PointOfSale' element value.
     * 
     * @param pointOfSale
     */
    public void setPointOfSale(PointOfSaleType pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @return value
     */
    public MessageParamsBaseType getParameters() {
        return parameters;
    }

    /** 
     * Set the 'Parameters' element value. Parameters that influence overall message results.

    Note: These capabilities may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only. The technical implementation of this capability is not dictated by this specification. 
     * 
     * @param parameters
     */
    public void setParameters(MessageParamsBaseType parameters) {
        this.parameters = parameters;
    }

    /** 
     * Get the 'Departure' element value.
     * 
     * @return value
     */
    public FlightDepartureType getQueryDeparture() {
        return queryDeparture;
    }

    /** 
     * Set the 'Departure' element value.
     * 
     * @param queryDeparture
     */
    public void setQueryDeparture(FlightDepartureType queryDeparture) {
        this.queryDeparture = queryDeparture;
    }

    /** 
     * Get the 'Arrival' element value.
     * 
     * @return value
     */
    public FlightArrivalType getQueryArrival() {
        return queryArrival;
    }

    /** 
     * Set the 'Arrival' element value.
     * 
     * @param queryArrival
     */
    public void setQueryArrival(FlightArrivalType queryArrival) {
        this.queryArrival = queryArrival;
    }

    /** 
     * Get the 'FareBasisCode' element value.
     * 
     * @return value
     */
    public FareBasisCodeType getQueryFareBasisCode() {
        return queryFareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value.
     * 
     * @param queryFareBasisCode
     */
    public void setQueryFareBasisCode(FareBasisCodeType queryFareBasisCode) {
        this.queryFareBasisCode = queryFareBasisCode;
    }

    /** 
     * Get the 'AirlineID' element value.
     * 
     * @return value
     */
    public AirlineIDType getQueryAirlineID() {
        return queryAirlineID;
    }

    /** 
     * Set the 'AirlineID' element value.
     * 
     * @param queryAirlineID
     */
    public void setQueryAirlineID(AirlineIDType queryAirlineID) {
        this.queryAirlineID = queryAirlineID;
    }

    /** 
     * Get the 'FareCode' element value.
     * 
     * @return value
     */
    public FareCode getQueryFareCode() {
        return queryFareCode;
    }

    /** 
     * Set the 'FareCode' element value.
     * 
     * @param queryFareCode
     */
    public void setQueryFareCode(FareCode queryFareCode) {
        this.queryFareCode = queryFareCode;
    }

    /** 
     * Get the 'FareInd' element value.
     * 
     * @return value
     */
    public FareInd getQueryFareInd() {
        return queryFareInd;
    }

    /** 
     * Set the 'FareInd' element value.
     * 
     * @param queryFareInd
     */
    public void setQueryFareInd(FareInd queryFareInd) {
        this.queryFareInd = queryFareInd;
    }

    /** 
     * Get the 'SpecialFare' element value. Special fares, which may be private or negotiated fares.
     * 
     * @return value
     */
    public FareQualifierType getQuerySpecialFare() {
        return querySpecialFare;
    }

    /** 
     * Set the 'SpecialFare' element value. Special fares, which may be private or negotiated fares.
     * 
     * @param querySpecialFare
     */
    public void setQuerySpecialFare(FareQualifierType querySpecialFare) {
        this.querySpecialFare = querySpecialFare;
    }

    /** 
     * Get the 'FareQualifierCodes' element value.
     * 
     * @return value
     */
    public FareQualifierCodes getQueryFareQualifierCodes() {
        return queryFareQualifierCodes;
    }

    /** 
     * Set the 'FareQualifierCodes' element value.
     * 
     * @param queryFareQualifierCodes
     */
    public void setQueryFareQualifierCodes(
            FareQualifierCodes queryFareQualifierCodes) {
        this.queryFareQualifierCodes = queryFareQualifierCodes;
    }

    /** 
     * Get the 'RuleCategories' element value. Core Fare Rules query parameters.
     * 
     * @return value
     */
    public RuleCategories getRuleCategories() {
        return ruleCategories;
    }

    /** 
     * Set the 'RuleCategories' element value. Core Fare Rules query parameters.
     * 
     * @param ruleCategories
     */
    public void setRuleCategories(RuleCategories ruleCategories) {
        this.ruleCategories = ruleCategories;
    }

    /** 
     * Get the 'FareTextInd' element value.
     * 
     * @return value
     */
    public FareTextInd getQueryFareTextInd() {
        return queryFareTextInd;
    }

    /** 
     * Set the 'FareTextInd' element value.
     * 
     * @param queryFareTextInd
     */
    public void setQueryFareTextInd(FareTextInd queryFareTextInd) {
        this.queryFareTextInd = queryFareTextInd;
    }

    /** 
     * Get the 'FareReferenceKey' element value.
     * 
     * @return value
     */
    public FareReferenceKey getQueryFareReferenceKey() {
        return queryFareReferenceKey;
    }

    /** 
     * Set the 'FareReferenceKey' element value.
     * 
     * @param queryFareReferenceKey
     */
    public void setQueryFareReferenceKey(FareReferenceKey queryFareReferenceKey) {
        this.queryFareReferenceKey = queryFareReferenceKey;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public FareRulesReqMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(FareRulesReqMetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Fare Rule Category(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleCategories" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:FareRuleCategory" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RuleCategories implements Serializable
    {
        private List<FareRuleCategory> fareRuleCategoryList = new ArrayList<FareRuleCategory>();

        /** 
         * Get the list of 'FareRuleCategory' element items.
         * 
         * @return list
         */
        public List<FareRuleCategory> getFareRuleCategoryList() {
            return fareRuleCategoryList;
        }

        /** 
         * Set the list of 'FareRuleCategory' element items.
         * 
         * @param list
         */
        public void setFareRuleCategoryList(List<FareRuleCategory> list) {
            fareRuleCategoryList = list;
        }
    }
}
