
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FareRules transaction set returns the filed details of a specific fare basis code (FBC).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRulesRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Party" minOccurs="0"/>
 *         &lt;xs:element type="ns:ProcessingResultType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element name="Rules" minOccurs="0">
 *           &lt;!-- Reference to inner class Rules -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="ns:FareRulesResMetadataType" name="Metadata" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FareRulesRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private MsgPartiesType party;
    private ProcessingResultType processing;
    private Rules rules;
    private FareRulesResMetadataType metadata;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.party = party;
    }

    /** 
     * Get the 'Processing' element value.
     * 
     * @return value
     */
    public ProcessingResultType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value.
     * 
     * @param processing
     */
    public void setProcessing(ProcessingResultType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'Rules' element value.
     * 
     * @return value
     */
    public Rules getRules() {
        return rules;
    }

    /** 
     * Set the 'Rules' element value.
     * 
     * @param rules
     */
    public void setRules(Rules rules) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.rules = rules;
    }

    /** 
     * Get the 'Metadata' element value. Metadata List(s).
     * 
     * @return value
     */
    public FareRulesResMetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Metadata List(s).
     * 
     * @param metadata
     */
    public void setMetadata(FareRulesResMetadataType metadata) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.metadata = metadata;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Fare Rules.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rules" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:Departure"/>
     *       &lt;xs:element ref="ns:Arrival"/>
     *       &lt;xs:element ref="ns:FareBasisCode"/>
     *       &lt;xs:element ref="ns:AirlineID"/>
     *       &lt;xs:element ref="ns:FareCode" minOccurs="0"/>
     *       &lt;xs:element name="Rule" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Rule -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rules implements Serializable
    {
        private FlightDepartureType departure;
        private FlightArrivalType arrival;
        private FareBasisCodeType fareBasisCode;
        private AirlineIDType airlineID;
        private FareCode fareCode;
        private List<Rule> ruleList = new ArrayList<Rule>();

        /** 
         * Get the 'Departure' element value.
         * 
         * @return value
         */
        public FlightDepartureType getDeparture() {
            return departure;
        }

        /** 
         * Set the 'Departure' element value.
         * 
         * @param departure
         */
        public void setDeparture(FlightDepartureType departure) {
            this.departure = departure;
        }

        /** 
         * Get the 'Arrival' element value.
         * 
         * @return value
         */
        public FlightArrivalType getArrival() {
            return arrival;
        }

        /** 
         * Set the 'Arrival' element value.
         * 
         * @param arrival
         */
        public void setArrival(FlightArrivalType arrival) {
            this.arrival = arrival;
        }

        /** 
         * Get the 'FareBasisCode' element value.
         * 
         * @return value
         */
        public FareBasisCodeType getFareBasisCode() {
            return fareBasisCode;
        }

        /** 
         * Set the 'FareBasisCode' element value.
         * 
         * @param fareBasisCode
         */
        public void setFareBasisCode(FareBasisCodeType fareBasisCode) {
            this.fareBasisCode = fareBasisCode;
        }

        /** 
         * Get the 'AirlineID' element value.
         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value.
         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            this.airlineID = airlineID;
        }

        /** 
         * Get the 'FareCode' element value.
         * 
         * @return value
         */
        public FareCode getFareCode() {
            return fareCode;
        }

        /** 
         * Set the 'FareCode' element value.
         * 
         * @param fareCode
         */
        public void setFareCode(FareCode fareCode) {
            this.fareCode = fareCode;
        }

        /** 
         * Get the list of 'Rule' element items.
         * 
         * @return list
         */
        public List<Rule> getRuleList() {
            return ruleList;
        }

        /** 
         * Set the list of 'Rule' element items.
         * 
         * @param list
         */
        public void setRuleList(List<Rule> list) {
            ruleList = list;
        }
        /** 
         * Fare Rule Category and Description.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rule" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="ns:FareRuleCategory"/>
         *       &lt;xs:element type="xs:string" name="Text" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Rule implements Serializable
        {
            private FareRuleCategory fareRuleCategory;
            private List<String> textList = new ArrayList<String>();

            /** 
             * Get the 'FareRuleCategory' element value.
             * 
             * @return value
             */
            public FareRuleCategory getFareRuleCategory() {
                return fareRuleCategory;
            }

            /** 
             * Set the 'FareRuleCategory' element value.
             * 
             * @param fareRuleCategory
             */
            public void setFareRuleCategory(FareRuleCategory fareRuleCategory) {
                this.fareRuleCategory = fareRuleCategory;
            }

            /** 
             * Get the list of 'Text' element items. Fare Rule Text.
             * 
             * @return list
             */
            public List<String> getTextList() {
                return textList;
            }

            /** 
             * Set the list of 'Text' element items. Fare Rule Text.
             * 
             * @param list
             */
            public void setTextList(List<String> list) {
                textList = list;
            }
        }
    }
}
