
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FileRetrieveRQ/ FileListRS transaction set supplements other NDC shopping messages with payloads designed to efficiently exchange offer-associated media using IDs and URLs.

 Using the FileRetrieveRQ message, implementers can subsequently retrieve binary encoded files—such as images or PDFs—from the IDs or URLs in a shopping response message that are returned in the FileListRS message.

 This message pair also supports scenarios where trading partners maintain a physical cache of offer associated media from other trading partners based on media IDs and/or URLs.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FileRetrieveRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element ref="ns:Document"/>
 *       &lt;xs:element ref="ns:Party"/>
 *       &lt;xs:element name="Query">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="ImageIDs" minOccurs="0">
 *               &lt;!-- Reference to inner class ImageIDs -->
 *             &lt;/xs:element>
 *             &lt;xs:element name="Attachments" minOccurs="0">
 *               &lt;!-- Reference to inner class Attachments -->
 *             &lt;/xs:element>
 *             &lt;xs:element ref="ns:AugmentationPoint" minOccurs="0"/>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FileRetrieveRQ implements Serializable
{
    private MsgDocumentType document;
    private MsgPartiesType party;
    private ImageIDs imageIDs;
    private Attachments attachments;
    private AugPointInfoType queryAugmentationPoint;
    private Policies policies;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        this.document = document;
    }

    /** 
     * Get the 'Party' element value.
     * 
     * @return value
     */
    public MsgPartiesType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value.
     * 
     * @param party
     */
    public void setParty(MsgPartiesType party) {
        this.party = party;
    }

    /** 
     * Get the 'ImageIDs' element value. Core query parameters.
     * 
     * @return value
     */
    public ImageIDs getImageIDs() {
        return imageIDs;
    }

    /** 
     * Set the 'ImageIDs' element value. Core query parameters.
     * 
     * @param imageIDs
     */
    public void setImageIDs(ImageIDs imageIDs) {
        this.imageIDs = imageIDs;
    }

    /** 
     * Get the 'Attachments' element value. Core query parameters.
     * 
     * @return value
     */
    public Attachments getAttachments() {
        return attachments;
    }

    /** 
     * Set the 'Attachments' element value. Core query parameters.
     * 
     * @param attachments
     */
    public void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    /** 
     * Get the 'AugmentationPoint' element value.
     * 
     * @return value
     */
    public AugPointInfoType getQueryAugmentationPoint() {
        return queryAugmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value.
     * 
     * @param queryAugmentationPoint
     */
    public void setQueryAugmentationPoint(
            AugPointInfoType queryAugmentationPoint) {
        this.queryAugmentationPoint = queryAugmentationPoint;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        this.policies = policies;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Image(s) to Retrieve.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ImageIDs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ns:ImageID" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ImageIDs implements Serializable
    {
        private List<ImageID> imageIDList = new ArrayList<ImageID>();

        /** 
         * Get the list of 'ImageID' element items.
         * 
         * @return list
         */
        public List<ImageID> getImageIDList() {
            return imageIDList;
        }

        /** 
         * Set the list of 'ImageID' element items.
         * 
         * @param list
         */
        public void setImageIDList(List<ImageID> list) {
            imageIDList = list;
        }
    }
    /** 
     * Attachment(s) to Retrieve.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Attachments" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AttachmentURI" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AttachmentURI -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Attachments implements Serializable
    {
        private List<AttachmentURI> attachmentURIList = new ArrayList<AttachmentURI>();

        /** 
         * Get the list of 'AttachmentURI' element items.
         * 
         * @return list
         */
        public List<AttachmentURI> getAttachmentURIList() {
            return attachmentURIList;
        }

        /** 
         * Set the list of 'AttachmentURI' element items.
         * 
         * @param list
         */
        public void setAttachmentURIList(List<AttachmentURI> list) {
            attachmentURIList = list;
        }
        /** 
         * Media attachment Uniform Resource Identifier (URI).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AttachmentURI" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * 
         * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
         *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
         * &lt;/xs:attributeGroup>
         * </pre>
         */
        public static class AttachmentURI implements Serializable
        {
            private String string;
            private String refs;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @return value
             */
            public String getRefs() {
                return refs;
            }

            /** 
             * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
             * 
             * @param refs
             */
            public void setRefs(String refs) {
                this.refs = refs;
            }
        }
    }
}
