
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The FileRetrieveRQ/ FileListRS transaction set supplements other NDC shopping messages with payloads designed to efficiently exchange offer-associated media using IDs and URLs.

 Using the FileRetrieveRQ message, implementers can subsequently retrieve binary encoded files—such as images or PDFs—from the IDs or URLs in a shopping response message that are returned in the FileListRS message.

 This message pair also supports scenarios where trading partners maintain a physical cache of offer associated media from other trading partners based on media IDs and/or URLs.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FileRetrieveRS">
 *   &lt;xs:complexType>
 *     &lt;xs:choice>
 *       &lt;xs:sequence>
 *         &lt;xs:element ref="ns:Document"/>
 *         &lt;xs:element type="ns:SuccessType" name="Success"/>
 *         &lt;xs:element type="ns:WarningsType" name="Warnings" minOccurs="0"/>
 *         &lt;xs:element type="ns:ProcessingResultType" name="Processing" minOccurs="0"/>
 *         &lt;xs:element name="Files" minOccurs="0">
 *           &lt;!-- Reference to inner class Files -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="ns:MediaMetadatas" minOccurs="0"/>
 *         &lt;xs:element ref="ns:Policies" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:element ref="ns:Errors"/>
 *     &lt;/xs:choice>
 *     &lt;xs:attributeGroup ref="ns:IATA_PayloadStdAttributes"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class FileRetrieveRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int DOCUMENT_CHOICE = 0;
    private static final int ERRORS_CHOICE = 1;
    private MsgDocumentType document;
    private SuccessType success;
    private WarningsType warnings;
    private ProcessingResultType processing;
    private Files files;
    private MediaMetadatas mediaMetadatas;
    private Policies policies;
    private ErrorsType errors;
    private IATAPayloadStdAttributes IATAPayloadStdAttributes;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Document is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifDocument() {
        return choiceSelect == DOCUMENT_CHOICE;
    }

    /** 
     * Get the 'Document' element value.
     * 
     * @return value
     */
    public MsgDocumentType getDocument() {
        return document;
    }

    /** 
     * Set the 'Document' element value.
     * 
     * @param document
     */
    public void setDocument(MsgDocumentType document) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.document = document;
    }

    /** 
     * Get the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @return value
     */
    public SuccessType getSuccess() {
        return success;
    }

    /** 
     * Set the 'Success' element value. The presence of the empty Success element explicitly indicates that the message succeeded.
     * 
     * @param success
     */
    public void setSuccess(SuccessType success) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.success = success;
    }

    /** 
     * Get the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @return value
     */
    public WarningsType getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value. Used in conjunction with the Success element to define one or more business errors.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsType warnings) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.warnings = warnings;
    }

    /** 
     * Get the 'Processing' element value. Transaction Processing Results, including processing status, alerts, business warnings, supplemental marketing messages and policy.
     * 
     * @return value
     */
    public ProcessingResultType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value. Transaction Processing Results, including processing status, alerts, business warnings, supplemental marketing messages and policy.
     * 
     * @param processing
     */
    public void setProcessing(ProcessingResultType processing) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.processing = processing;
    }

    /** 
     * Get the 'Files' element value.
     * 
     * @return value
     */
    public Files getFiles() {
        return files;
    }

    /** 
     * Set the 'Files' element value.
     * 
     * @param files
     */
    public void setFiles(Files files) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.files = files;
    }

    /** 
     * Get the 'MediaMetadatas' element value.
     * 
     * @return value
     */
    public MediaMetadatas getMediaMetadatas() {
        return mediaMetadatas;
    }

    /** 
     * Set the 'MediaMetadatas' element value.
     * 
     * @param mediaMetadatas
     */
    public void setMediaMetadatas(MediaMetadatas mediaMetadatas) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.mediaMetadatas = mediaMetadatas;
    }

    /** 
     * Get the 'Policies' element value. Message Policy information.
     * 
     * @return value
     */
    public Policies getPolicies() {
        return policies;
    }

    /** 
     * Set the 'Policies' element value. Message Policy information.
     * 
     * @param policies
     */
    public void setPolicies(Policies policies) {
        setChoiceSelect(DOCUMENT_CHOICE);
        this.policies = policies;
    }

    /** 
     * Check if Errors is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrors() {
        return choiceSelect == ERRORS_CHOICE;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsType getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsType errors) {
        setChoiceSelect(ERRORS_CHOICE);
        this.errors = errors;
    }

    /** 
     * Get the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @return value
     */
    public IATAPayloadStdAttributes getIATAPayloadStdAttributes() {
        return IATAPayloadStdAttributes;
    }

    /** 
     * Set the 'IATA_PayloadStdAttributes' attributeGroup value.
     * 
     * @param IATAPayloadStdAttributes
     */
    public void setIATAPayloadStdAttributes(
            IATAPayloadStdAttributes IATAPayloadStdAttributes) {
        this.IATAPayloadStdAttributes = IATAPayloadStdAttributes;
    }
    /** 
     * Media, File Attachements and Binary Encoded Image(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Files" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:MediaAttachmentType" name="File" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Files implements Serializable
    {
        private List<MediaAttachmentType> fileList = new ArrayList<MediaAttachmentType>();

        /** 
         * Get the list of 'File' element items. Media File Detail.
         * 
         * @return list
         */
        public List<MediaAttachmentType> getFileList() {
            return fileList;
        }

        /** 
         * Set the list of 'File' element items. Media File Detail.
         * 
         * @param list
         */
        public void setFileList(List<MediaAttachmentType> list) {
            fileList = list;
        }
    }
}
