
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight-related Metadata, including Flight and Itinerary.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight">
 *   &lt;xs:complexType>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FlightInner -->
 *     &lt;/xs:choice>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class Flight implements Serializable
{
    private List<FlightInner> flightList = new ArrayList<FlightInner>();

    /** 
     * Get the list of 'Flight' element items.
     * 
     * @return list
     */
    public List<FlightInner> getFlightList() {
        return flightList;
    }

    /** 
     * Set the list of 'Flight' element items.
     * 
     * @param list
     */
    public void setFlightList(List<FlightInner> list) {
        flightList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element ref="ns:FlightMetadatas"/>
     *   &lt;xs:element ref="ns:ItineraryMetadata"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class FlightInner implements Serializable
    {
        private int flightListSelect = -1;
        private static final int FLIGHT_METADATAS_CHOICE = 0;
        private static final int ITINERARY_METADATA_CHOICE = 1;
        private FlightMetadatas flightMetadatas;
        private ItineraryMetadataType itineraryMetadata;

        private void setFlightListSelect(int choice) {
            if (flightListSelect == -1) {
                flightListSelect = choice;
            } else if (flightListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearFlightListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearFlightListSelect() {
            flightListSelect = -1;
        }

        /** 
         * Check if FlightMetadatas is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFlightMetadatas() {
            return flightListSelect == FLIGHT_METADATAS_CHOICE;
        }

        /** 
         * Get the 'FlightMetadatas' element value.
         * 
         * @return value
         */
        public FlightMetadatas getFlightMetadatas() {
            return flightMetadatas;
        }

        /** 
         * Set the 'FlightMetadatas' element value.
         * 
         * @param flightMetadatas
         */
        public void setFlightMetadatas(FlightMetadatas flightMetadatas) {
            setFlightListSelect(FLIGHT_METADATAS_CHOICE);
            this.flightMetadatas = flightMetadatas;
        }

        /** 
         * Check if ItineraryMetadata is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifItineraryMetadata() {
            return flightListSelect == ITINERARY_METADATA_CHOICE;
        }

        /** 
         * Get the 'ItineraryMetadata' element value.
         * 
         * @return value
         */
        public ItineraryMetadataType getItineraryMetadata() {
            return itineraryMetadata;
        }

        /** 
         * Set the 'ItineraryMetadata' element value.
         * 
         * @param itineraryMetadata
         */
        public void setItineraryMetadata(ItineraryMetadataType itineraryMetadata) {
            setFlightListSelect(ITINERARY_METADATA_CHOICE);
            this.itineraryMetadata = itineraryMetadata;
        }
    }
}
