
package com.gridnine.xtrip.server.gds.tandc.wsmodel;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * FLIGHT DETAIL definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightDetailType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:FlightSegmentType" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FlightDistance" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FlightDuration" minOccurs="0"/>
 *     &lt;xs:element name="Stops" minOccurs="0">
 *       &lt;!-- Reference to inner class Stops -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="ns:ResDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TourOperatorFlightID" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightDetailType implements Serializable
{
    private FlightSegmentType flightSegmentType;
    private FlightDistanceType flightDistance;
    private FlightDurationType flightDuration;
    private Stops stops;
    private ResDateTime resDateTime;
    private String tourOperatorFlightID;
    private String refs;

    /** 
     * Get the 'FlightSegmentType' element value.
     * 
     * @return value
     */
    public FlightSegmentType getFlightSegmentType() {
        return flightSegmentType;
    }

    /** 
     * Set the 'FlightSegmentType' element value.
     * 
     * @param flightSegmentType
     */
    public void setFlightSegmentType(FlightSegmentType flightSegmentType) {
        this.flightSegmentType = flightSegmentType;
    }

    /** 
     * Get the 'FlightDistance' element value.
     * 
     * @return value
     */
    public FlightDistanceType getFlightDistance() {
        return flightDistance;
    }

    /** 
     * Set the 'FlightDistance' element value.
     * 
     * @param flightDistance
     */
    public void setFlightDistance(FlightDistanceType flightDistance) {
        this.flightDistance = flightDistance;
    }

    /** 
     * Get the 'FlightDuration' element value.
     * 
     * @return value
     */
    public FlightDurationType getFlightDuration() {
        return flightDuration;
    }

    /** 
     * Set the 'FlightDuration' element value.
     * 
     * @param flightDuration
     */
    public void setFlightDuration(FlightDurationType flightDuration) {
        this.flightDuration = flightDuration;
    }

    /** 
     * Get the 'Stops' element value.
     * 
     * @return value
     */
    public Stops getStops() {
        return stops;
    }

    /** 
     * Set the 'Stops' element value.
     * 
     * @param stops
     */
    public void setStops(Stops stops) {
        this.stops = stops;
    }

    /** 
     * Get the 'ResDateTime' element value.
     * 
     * @return value
     */
    public ResDateTime getResDateTime() {
        return resDateTime;
    }

    /** 
     * Set the 'ResDateTime' element value.
     * 
     * @param resDateTime
     */
    public void setResDateTime(ResDateTime resDateTime) {
        this.resDateTime = resDateTime;
    }

    /** 
     * Get the 'TourOperatorFlightID' element value. Tour Operator Flight ID.

    Note: This is an ID for the flight as represented by a Tour Operator. This flight is not necessarily in the inventory of an airline as it is a code created by tour operators.  
     * 
     * @return value
     */
    public String getTourOperatorFlightID() {
        return tourOperatorFlightID;
    }

    /** 
     * Set the 'TourOperatorFlightID' element value. Tour Operator Flight ID.

    Note: This is an ID for the flight as represented by a Tour Operator. This flight is not necessarily in the inventory of an airline as it is a code created by tour operators.  
     * 
     * @param tourOperatorFlightID
     */
    public void setTourOperatorFlightID(String tourOperatorFlightID) {
        this.tourOperatorFlightID = tourOperatorFlightID;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Flight Stop Quantity and Location(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/EDIST/2017.2" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Stops" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:integer" name="StopQuantity" minOccurs="0"/>
     *       &lt;xs:element ref="ns:StopLocations" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Stops implements Serializable
    {
        private BigInteger stopQuantity;
        private StopLocationType stopLocations;

        /** 
         * Get the 'StopQuantity' element value. Stop Quantity. Example: 1
         * 
         * @return value
         */
        public BigInteger getStopQuantity() {
            return stopQuantity;
        }

        /** 
         * Set the 'StopQuantity' element value. Stop Quantity. Example: 1
         * 
         * @param stopQuantity
         */
        public void setStopQuantity(BigInteger stopQuantity) {
            this.stopQuantity = stopQuantity;
        }

        /** 
         * Get the 'StopLocations' element value.
         * 
         * @return value
         */
        public StopLocationType getStopLocations() {
            return stopLocations;
        }

        /** 
         * Set the 'StopLocations' element value.
         * 
         * @param stopLocations
         */
        public void setStopLocations(StopLocationType stopLocations) {
            this.stopLocations = stopLocations;
        }
    }
}
